/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.InternalServiceRegistry;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProvider;

public class DelegatingServiceRegistry
implements InternalServiceRegistry {
    private final long consumerID;
    private final Map<Class<?>, List<ServiceProvider>> serviceProviderMap;
    private final Map<Class<?>, List<ImplementationProvidedServiceProvider>> implementationProvidedServiceProviderMap;
    private ManagedEntity owningEntity;

    public DelegatingServiceRegistry(long consumerID, ServiceProvider[] providers, ImplementationProvidedServiceProvider[] implementationProvidedProviders) {
        this.consumerID = consumerID;
        HashMap<Class, LinkedList<ServiceProvider>> tempProviders = new HashMap<Class, LinkedList<ServiceProvider>>();
        for (ServiceProvider provider : providers) {
            for (Class serviceType : provider.getProvidedServiceTypes()) {
                LinkedList<ServiceProvider> listForType = (LinkedList<ServiceProvider>)tempProviders.get(serviceType);
                if (null == listForType) {
                    listForType = new LinkedList<ServiceProvider>();
                    tempProviders.put(serviceType, listForType);
                }
                listForType.add(provider);
            }
        }
        this.serviceProviderMap = Collections.unmodifiableMap(tempProviders);
        HashMap tempBuiltInProviders = new HashMap();
        for (ImplementationProvidedServiceProvider provider : implementationProvidedProviders) {
            for (Class<?> serviceType : provider.getProvidedServiceTypes()) {
                LinkedList<ImplementationProvidedServiceProvider> listForType = (LinkedList<ImplementationProvidedServiceProvider>)tempBuiltInProviders.get(serviceType);
                if (null == listForType) {
                    listForType = new LinkedList<ImplementationProvidedServiceProvider>();
                    tempBuiltInProviders.put(serviceType, listForType);
                }
                listForType.add(provider);
            }
        }
        this.implementationProvidedServiceProviderMap = Collections.unmodifiableMap(tempBuiltInProviders);
    }

    public <T> T getService(ServiceConfiguration<T> configuration) {
        T builtInService = this.getBuiltInService(configuration);
        T externalService = this.getExternalService(configuration);
        if (null != builtInService && null != externalService) {
            throw new IllegalArgumentException("Both built-in and external service found for type: " + configuration.getServiceType());
        }
        return null != builtInService ? builtInService : externalService;
    }

    @Override
    public void setOwningEntity(ManagedEntity entity) {
        Assert.assertNull((Object)this.owningEntity);
        Assert.assertNotNull((Object)entity);
        this.owningEntity = entity;
    }

    private <T> T getBuiltInService(ServiceConfiguration<T> configuration) {
        Class serviceType = configuration.getServiceType();
        List<ImplementationProvidedServiceProvider> serviceProviders = this.implementationProvidedServiceProviderMap.get(serviceType);
        T service = null;
        if (null != serviceProviders) {
            for (ImplementationProvidedServiceProvider provider : serviceProviders) {
                T oneService = provider.getService(this.consumerID, this.owningEntity, configuration);
                if (null == oneService) continue;
                if (null != service) {
                    throw new IllegalArgumentException("Multiple built-in service providers matched for type: " + serviceType);
                }
                service = oneService;
            }
        }
        return service;
    }

    private <T> T getExternalService(ServiceConfiguration<T> configuration) {
        Class serviceType = configuration.getServiceType();
        List<ServiceProvider> serviceProviders = this.serviceProviderMap.get(serviceType);
        if (serviceProviders == null) {
            return null;
        }
        Object service = null;
        for (ServiceProvider provider : serviceProviders) {
            Object oneService = provider.getService(this.consumerID, configuration);
            if (null == oneService) continue;
            if (null != service) {
                throw new IllegalArgumentException("Multiple service providers matched for type: " + serviceType);
            }
            service = oneService;
        }
        return (T)service;
    }
}

