/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.net.NodeID;
import com.tc.object.ClientInstanceID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.services.ClientAccount;
import com.tc.util.Assert;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EntityClientCommunicatorService
implements ClientCommunicator {
    private final ConcurrentMap<NodeID, ClientAccount> clientAccounts;
    private final ManagedEntity owningEntity;

    public EntityClientCommunicatorService(ConcurrentMap<NodeID, ClientAccount> clientAccounts, ManagedEntity owningEntity) {
        Assert.assertNotNull(clientAccounts);
        Assert.assertNotNull((Object)owningEntity);
        this.clientAccounts = clientAccounts;
        this.owningEntity = owningEntity;
    }

    public void sendNoResponse(ClientDescriptor clientDescriptor, EntityResponse message) throws MessageCodecException {
        ClientDescriptorImpl rawDescriptor = (ClientDescriptorImpl)clientDescriptor;
        ClientAccount clientAccount = (ClientAccount)this.clientAccounts.get(rawDescriptor.getNodeID());
        if (clientAccount != null) {
            ClientInstanceID clientInstance = rawDescriptor.getClientInstanceID();
            byte[] payload = this.serialize(this.owningEntity.getCodec(), message);
            clientAccount.sendNoResponse(clientInstance, payload);
        }
    }

    public Future<Void> send(ClientDescriptor clientDescriptor, EntityResponse message) throws MessageCodecException {
        ClientDescriptorImpl rawDescriptor = (ClientDescriptorImpl)clientDescriptor;
        ClientAccount clientAccount = (ClientAccount)this.clientAccounts.get(rawDescriptor.getNodeID());
        if (clientAccount != null) {
            ClientInstanceID clientInstance = rawDescriptor.getClientInstanceID();
            byte[] payload = this.serialize(this.owningEntity.getCodec(), message);
            return clientAccount.send(clientInstance, payload);
        }
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return null;
            }
        };
    }

    private <R extends EntityResponse> byte[] serialize(MessageCodec<?, R> codec, EntityResponse response) throws MessageCodecException {
        return codec.encodeResponse(response);
    }
}

