/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.async.api.Sink;
import com.tc.entity.VoltronEntityMessage;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.EntityMessengerService;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.SingleThreadedTimer;
import com.tc.util.Assert;
import java.util.Collection;
import java.util.Collections;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProviderCleanupException;

public class EntityMessengerProvider
implements ImplementationProvidedServiceProvider {
    private final SingleThreadedTimer timer;
    private Sink<VoltronEntityMessage> messageSink;
    private boolean serverIsActive;

    public EntityMessengerProvider(SingleThreadedTimer timer) {
        Assert.assertNotNull((Object)timer);
        this.timer = timer;
    }

    @Override
    public <T> T getService(long consumerID, ManagedEntity owningEntity, ServiceConfiguration<T> configuration) {
        Assert.assertNotNull(this.messageSink);
        Assert.assertNotNull((Object)owningEntity);
        T service = null;
        if (this.serverIsActive) {
            service = configuration.getServiceType().cast(new EntityMessengerService(this.timer, this.messageSink, owningEntity));
        }
        return service;
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        return Collections.singleton(IEntityMessenger.class);
    }

    @Override
    public void clear() throws ServiceProviderCleanupException {
    }

    @Override
    public void serverDidBecomeActive() {
        Assert.assertNotNull(this.messageSink);
        this.serverIsActive = true;
    }

    public void setMessageSink(Sink<VoltronEntityMessage> messageSink) {
        Assert.assertNotNull(messageSink);
        this.messageSink = messageSink;
    }
}

