/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.async.api.Sink;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.ClientID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.handler.RetirementManager;
import com.tc.services.SingleThreadedTimer;
import com.tc.util.Assert;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EntityMessengerService
implements IEntityMessenger {
    private final SingleThreadedTimer timer;
    private final Sink<VoltronEntityMessage> messageSink;
    private final ManagedEntity owningEntity;
    private final RetirementManager retirementManager;
    private final MessageCodec<EntityMessage, ?> codec;
    private final EntityDescriptor fakeDescriptor;

    public EntityMessengerService(SingleThreadedTimer timer, Sink<VoltronEntityMessage> messageSink, ManagedEntity owningEntity) {
        Assert.assertNotNull((Object)timer);
        Assert.assertNotNull(messageSink);
        Assert.assertNotNull((Object)owningEntity);
        this.timer = timer;
        this.messageSink = messageSink;
        this.owningEntity = owningEntity;
        this.retirementManager = owningEntity.getRetirementManager();
        Assert.assertTrue((null != this.retirementManager ? 1 : 0) != 0);
        this.codec = owningEntity.getCodec();
        this.fakeDescriptor = EntityDescriptor.createDescriptorForLifecycle((EntityID)owningEntity.getID(), (long)owningEntity.getVersion());
    }

    public void messageSelf(EntityMessage message) throws MessageCodecException {
        this.scheduleMessage(message);
    }

    public void messageSelfAndDeferRetirement(EntityMessage originalMessageToDefer, EntityMessage newMessageToSchedule) throws MessageCodecException {
        this.retirementManager.deferRetirement(originalMessageToDefer, newMessageToSchedule);
        this.scheduleMessage(newMessageToSchedule);
    }

    public IEntityMessenger.ScheduledToken messageSelfAfterDelay(EntityMessage message, long millisBeforeSend) throws MessageCodecException {
        final FakeEntityMessage interEntityMessage = this.encodeAsFake(message);
        long startTimeMillis = this.timer.currentTimeMillis() + millisBeforeSend;
        long id = this.timer.addDelayed(new Runnable(){

            @Override
            public void run() {
                if (!EntityMessengerService.this.owningEntity.isDestroyed()) {
                    EntityMessengerService.this.messageSink.addSingleThreaded((Object)interEntityMessage);
                }
            }
        }, startTimeMillis);
        return new TokenWrapper(id);
    }

    public IEntityMessenger.ScheduledToken messageSelfPeriodically(EntityMessage message, long millisBetweenSends) throws MessageCodecException {
        FakeEntityMessage interEntityMessage = this.encodeAsFake(message);
        long startTimeMillis = this.timer.currentTimeMillis() + millisBetweenSends;
        SelfDestructiveRunnable runnable = new SelfDestructiveRunnable(this.messageSink, this.owningEntity, interEntityMessage);
        long id = this.timer.addPeriodic(runnable, startTimeMillis, millisBetweenSends);
        runnable.prepareForCancel(this.timer, id);
        return new TokenWrapper(id);
    }

    public void cancelTimedMessage(IEntityMessenger.ScheduledToken token) {
        this.timer.cancel(((TokenWrapper)token).token);
    }

    private void scheduleMessage(EntityMessage message) throws MessageCodecException {
        FakeEntityMessage interEntityMessage = this.encodeAsFake(message);
        this.messageSink.addSingleThreaded((Object)interEntityMessage);
    }

    private FakeEntityMessage encodeAsFake(EntityMessage message) throws MessageCodecException {
        byte[] serializedMessage = this.codec.encodeMessage(message);
        FakeEntityMessage interEntityMessage = new FakeEntityMessage(this.fakeDescriptor, message, serializedMessage);
        return interEntityMessage;
    }

    private static class TokenWrapper
    implements IEntityMessenger.ScheduledToken {
        public final long token;

        public TokenWrapper(long token) {
            this.token = token;
        }
    }

    private static class SelfDestructiveRunnable
    implements Runnable {
        private final Sink<VoltronEntityMessage> messageSink;
        private final ManagedEntity owningEntity;
        private final FakeEntityMessage message;
        private SingleThreadedTimer timer;
        private long id;

        public SelfDestructiveRunnable(Sink<VoltronEntityMessage> messageSink, ManagedEntity owningEntity, FakeEntityMessage message) {
            this.messageSink = messageSink;
            this.owningEntity = owningEntity;
            this.message = message;
        }

        public void prepareForCancel(SingleThreadedTimer timer, long id) {
            this.timer = timer;
            this.id = id;
        }

        @Override
        public void run() {
            if (this.owningEntity.isDestroyed()) {
                this.timer.cancel(this.id);
            } else {
                this.messageSink.addSingleThreaded((Object)this.message);
            }
        }
    }

    private static class FakeEntityMessage
    implements VoltronEntityMessage {
        private final EntityDescriptor descriptor;
        private final EntityMessage identityMessage;
        private final byte[] message;

        public FakeEntityMessage(EntityDescriptor descriptor, EntityMessage identityMessage, byte[] message) {
            this.descriptor = descriptor;
            this.identityMessage = identityMessage;
            this.message = message;
        }

        public ClientID getSource() {
            return ClientID.NULL_ID;
        }

        public TransactionID getTransactionID() {
            return TransactionID.NULL_ID;
        }

        public EntityDescriptor getEntityDescriptor() {
            return this.descriptor;
        }

        public boolean doesRequireReplication() {
            return true;
        }

        public boolean doesRequestReceived() {
            return false;
        }

        public VoltronEntityMessage.Type getVoltronType() {
            return VoltronEntityMessage.Type.INVOKE_ACTION;
        }

        public byte[] getExtendedData() {
            return this.message;
        }

        public TransactionID getOldestTransactionOnClient() {
            return TransactionID.NULL_ID;
        }

        public EntityMessage getEntityMessage() {
            return this.identityMessage;
        }
    }
}

