/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.classloader.BuiltinService;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ServerID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.BestEffortsMonitoring;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.SingleThreadedTimer;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.IStripeMonitoring;
import org.terracotta.monitoring.PlatformServer;

@BuiltinService
public class LocalMonitoringProducer
implements ImplementationProvidedServiceProvider {
    private static final TCLogger LOGGER = TCLogging.getLogger(LocalMonitoringProducer.class);
    private final TerracottaServiceProviderRegistry globalRegistry;
    private final PlatformServer thisServer;
    private final Map<ServerID, PlatformServer> otherServers;
    private ActivePipeWrapper activeWrapper;
    private Map<Long, CacheNode> cachedTreeRoot;
    private BestEffortsMonitoring bestEfforts;

    public LocalMonitoringProducer(TerracottaServiceProviderRegistry globalRegistry, PlatformServer thisServer, SingleThreadedTimer timer) {
        this.globalRegistry = globalRegistry;
        this.thisServer = thisServer;
        this.otherServers = new HashMap<ServerID, PlatformServer>();
        this.cachedTreeRoot = new HashMap<Long, CacheNode>();
        this.bestEfforts = new BestEffortsMonitoring(timer);
    }

    public PlatformServer getLocalServerInfo() {
        return this.thisServer;
    }

    @Override
    public synchronized <T> T getService(final long consumerID, ManagedEntity owningEntity, ServiceConfiguration<T> configuration) {
        Class type = configuration.getServiceType();
        Assert.assertEquals((Object)type, IMonitoringProducer.class);
        if (null != this.cachedTreeRoot && !this.cachedTreeRoot.containsKey(consumerID)) {
            this.cachedTreeRoot.put(consumerID, new CacheNode(null));
        }
        final IStripeMonitoring underlyingCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(consumerID).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
        T service = null;
        if (null != underlyingCollector) {
            service = type.cast(new IMonitoringProducer(){

                public boolean addNode(String[] parents, String name, Serializable value) {
                    return LocalMonitoringProducer.this.addNodeFromShim(consumerID, underlyingCollector, parents, name, value);
                }

                public boolean removeNode(String[] parents, String name) {
                    return LocalMonitoringProducer.this.removeNodeFromShim(consumerID, underlyingCollector, parents, name);
                }

                public void pushBestEffortsData(String name, Serializable data) {
                    LocalMonitoringProducer.this.pushBestEffortsFromShim(consumerID, underlyingCollector, name, data);
                }
            });
        }
        return service;
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        return Collections.singleton(IMonitoringProducer.class);
    }

    @Override
    public void clear() throws ServiceProviderCleanupException {
    }

    @Override
    public synchronized void serverDidBecomeActive() {
    }

    public synchronized void serverIsActive() {
        IStripeMonitoring platformCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(0L).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
        if (null != platformCollector) {
            platformCollector.serverDidBecomeActive(this.thisServer);
            for (Map.Entry<Long, CacheNode> entry : this.cachedTreeRoot.entrySet()) {
                long consumerID = entry.getKey();
                final IStripeMonitoring underlyingCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(consumerID).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
                this.walkCacheChildren(new String[0], entry.getValue().children, new CacheWalker(){

                    @Override
                    public void didEnterNode(String[] parents, String name, Serializable value) {
                        underlyingCollector.addNode(LocalMonitoringProducer.this.thisServer, parents, name, value);
                    }
                });
            }
            this.bestEfforts.flushAfterActivePromotion(this.thisServer, this.globalRegistry);
        }
        this.cachedTreeRoot = null;
        this.bestEfforts = null;
        this.activeWrapper = null;
    }

    public synchronized void sendToNewActive(ActivePipeWrapper activeWrapper) {
        this.activeWrapper = activeWrapper;
        if (this.cachedTreeRoot != null) {
            for (Map.Entry<Long, CacheNode> entry : this.cachedTreeRoot.entrySet()) {
                final long consumerID = entry.getKey();
                this.walkCacheChildren(new String[0], entry.getValue().children, new CacheWalker(){

                    @Override
                    public void didEnterNode(String[] parents, String name, Serializable value) {
                        LocalMonitoringProducer.this.activeWrapper.addNode(consumerID, parents, name, value);
                    }
                });
            }
            this.bestEfforts.attachToNewActive(this.activeWrapper);
        }
    }

    public void serverDidJoinStripe(ServerID sender, PlatformServer platformServer) {
        IStripeMonitoring platformCollector;
        PlatformServer oldValue = this.otherServers.put(sender, platformServer);
        if (oldValue != null) {
            LOGGER.warn((Object)("multiple copies of server information are being reported.old=" + oldValue + " new=" + platformServer));
        }
        if (null != (platformCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(0L).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class)))) {
            platformCollector.serverDidJoinStripe(platformServer);
        }
    }

    public void serverDidLeaveStripe(ServerID nodeID) {
        IStripeMonitoring platformCollector;
        PlatformServer platformServer = this.otherServers.remove(nodeID);
        if (null != platformServer && null != (platformCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(0L).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class)))) {
            platformCollector.serverDidLeaveStripe(platformServer);
        }
    }

    public synchronized void handleRemoteAdd(ServerID sender, long consumerID, String[] parents, String name, Serializable value) {
        Assert.assertNull(this.cachedTreeRoot);
        IStripeMonitoring underlyingCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(consumerID).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
        if (null != underlyingCollector) {
            PlatformServer sendingServer = this.otherServers.get(sender);
            Assert.assertNotNull((Object)sendingServer);
            underlyingCollector.addNode(sendingServer, parents, name, value);
        }
    }

    public synchronized void handleRemoteRemove(ServerID sender, long consumerID, String[] parents, String name) {
        Assert.assertNull(this.cachedTreeRoot);
        IStripeMonitoring underlyingCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(consumerID).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
        if (null != underlyingCollector) {
            PlatformServer sendingServer = this.otherServers.get(sender);
            Assert.assertNotNull((Object)sendingServer);
            underlyingCollector.removeNode(sendingServer, parents, name);
        }
    }

    public synchronized void handleRemoteBestEffortsBatch(ServerID sender, long[] consumerIDs, String[] keys, Serializable[] values) {
        Assert.assertNull(this.cachedTreeRoot);
        for (int i = 0; i < consumerIDs.length; ++i) {
            IStripeMonitoring underlyingCollector = (IStripeMonitoring)this.globalRegistry.subRegistry(consumerIDs[i]).getService((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
            if (null == underlyingCollector) continue;
            PlatformServer sendingServer = this.otherServers.get(sender);
            Assert.assertNotNull((Object)sendingServer);
            underlyingCollector.pushBestEffortsData(sendingServer, keys[i], values[i]);
        }
    }

    public synchronized boolean isReadyToReceiveRemoteEvents() {
        return null == this.cachedTreeRoot;
    }

    private synchronized boolean addNodeFromShim(long consumerID, IStripeMonitoring underlyingCollector, String[] parents, String name, Serializable value) {
        boolean didStore = false;
        if (null != this.cachedTreeRoot) {
            CacheNode parentNode = this.findParent(consumerID, parents);
            if (null != parentNode) {
                parentNode.children.put(name, new CacheNode(value));
                if (null != this.activeWrapper) {
                    this.activeWrapper.addNode(consumerID, parents, name, value);
                }
                didStore = true;
            }
        } else {
            didStore = underlyingCollector.addNode(this.thisServer, parents, name, value);
        }
        return didStore;
    }

    private synchronized boolean removeNodeFromShim(long consumerID, IStripeMonitoring underlyingCollector, String[] parents, String name) {
        boolean didRemove = false;
        if (null != this.cachedTreeRoot) {
            CacheNode removed;
            CacheNode parentNode = this.findParent(consumerID, parents);
            if (null != parentNode && null != (removed = parentNode.children.remove(name))) {
                if (null != this.activeWrapper) {
                    this.activeWrapper.removeNode(consumerID, parents, name);
                }
                didRemove = true;
            }
        } else {
            didRemove = underlyingCollector.removeNode(this.thisServer, parents, name);
        }
        return didRemove;
    }

    private synchronized void pushBestEffortsFromShim(long consumerID, IStripeMonitoring underlyingCollector, String name, Serializable data) {
        if (null != this.bestEfforts) {
            this.bestEfforts.pushBestEfforts(consumerID, name, data);
        } else {
            underlyingCollector.pushBestEffortsData(this.thisServer, name, data);
        }
    }

    private CacheNode findParent(long consumerID, String[] parents) {
        CacheNode parentNode = null;
        if (null != this.cachedTreeRoot) {
            CacheNode oneNode = this.cachedTreeRoot.get(consumerID);
            for (int i = 0; parents != null && null != oneNode && i < parents.length; ++i) {
                oneNode = oneNode.children.get(parents[i]);
            }
            if (null != oneNode) {
                parentNode = oneNode;
            }
        }
        return parentNode;
    }

    private void walkCacheChildren(String[] parents, Map<String, CacheNode> nodeChildren, CacheWalker walker) {
        for (Map.Entry<String, CacheNode> child : nodeChildren.entrySet()) {
            this.walkCacheNode(parents, child.getKey(), child.getValue(), walker);
        }
    }

    private void walkCacheNode(String[] parents, String nodeName, CacheNode node, CacheWalker walker) {
        Assert.assertNotNull((Object)nodeName);
        walker.didEnterNode(parents, nodeName, node.data);
        String[] newParents = new String[parents.length + 1];
        System.arraycopy(parents, 0, newParents, 0, parents.length);
        newParents[parents.length] = nodeName;
        this.walkCacheChildren(newParents, node.children, walker);
    }

    private static interface CacheWalker {
        public void didEnterNode(String[] var1, String var2, Serializable var3);
    }

    private static class CacheNode {
        public final Serializable data;
        public final Map<String, CacheNode> children;

        public CacheNode(Serializable data) {
            this.data = data;
            this.children = new HashMap<String, CacheNode>();
        }
    }

    public static interface ActivePipeWrapper {
        public void addNode(long var1, String[] var3, String var4, Serializable var5);

        public void removeNode(long var1, String[] var3, String var4);

        public void pushBestEffortsBatch(long[] var1, String[] var2, Serializable[] var3);
    }
}

