/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.entity.StateDumper;

public class LogBasedStateDumper
implements StateDumper {
    private static final TCLogger LOGGER = TCLogging.getDumpLogger();
    private final ConcurrentMap<String, LogBasedStateDumper> instances = new ConcurrentHashMap<String, LogBasedStateDumper>();
    private final ConcurrentMap<String, String> dumpState = new ConcurrentHashMap<String, String>();
    private final LogBasedStateDumper parent;
    private final String name;

    public LogBasedStateDumper(String name) {
        this(name, null);
    }

    public LogBasedStateDumper(String name, LogBasedStateDumper parent) {
        this.name = parent != null ? parent.getName() + "." + name : name;
        this.parent = parent;
    }

    public StateDumper subStateDumper(String name) {
        this.instances.putIfAbsent(name, new LogBasedStateDumper(name, this));
        return (StateDumper)this.instances.get(name);
    }

    public void dumpState(String key, String value) {
        this.dumpState.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void logState() {
        if (this.dumpState.size() > 0) {
            LOGGER.info((Object)"\n***********************************************************************************\n");
            LOGGER.info((Object)(this.name + " state "));
            for (Map.Entry entry : this.dumpState.entrySet()) {
                LOGGER.info((Object)((String)entry.getKey() + "=" + (String)entry.getValue()));
            }
        }
        for (LogBasedStateDumper logBasedStateDumper : this.instances.values()) {
            logBasedStateDumper.logState();
        }
    }
}

