/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.util.Assert;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class SingleThreadedTimer {
    private final TimeSource timeSource;
    private final Thread timerThread = new Thread(){

        @Override
        public void run() {
            Runnable nextRunnable = SingleThreadedTimer.this.getNextRunnable();
            while (null != nextRunnable) {
                try {
                    nextRunnable.run();
                }
                catch (Throwable t) {
                    System.err.println("ERROR:  Unexpected exception in timer (timed events may be dropped)");
                    t.printStackTrace();
                }
                nextRunnable = SingleThreadedTimer.this.getNextRunnable();
            }
        }
    };
    private boolean threadIsRunning = false;
    private long nextId = 1L;
    private final PriorityQueue<ListElement> queue = new PriorityQueue<ListElement>(1, new Comparator<ListElement>(){

        @Override
        public int compare(ListElement o1, ListElement o2) {
            long delta = o1.startTimeMillis - o2.startTimeMillis;
            return 0L == delta ? 0 : (delta < 0L ? -1 : 1);
        }
    });
    private boolean isInPoke = false;

    public SingleThreadedTimer(TimeSource source) {
        this.timeSource = null != source ? source : new TimeSource(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.timerThread.setName("SingleThreadedTimer");
    }

    public synchronized void start() {
        this.threadIsRunning = true;
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        SingleThreadedTimer singleThreadedTimer = this;
        synchronized (singleThreadedTimer) {
            this.threadIsRunning = false;
            this.notifyAll();
        }
        this.timerThread.join();
    }

    public synchronized void poke() {
        this.isInPoke = true;
        while (this.isInPoke) {
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getLocalizedMessage());
            }
        }
    }

    public long currentTimeMillis() {
        return this.timeSource.currentTimeMillis();
    }

    public synchronized long addDelayed(Runnable toRun, long startTimeMillis) {
        return this.enqueueNewElement(toRun, startTimeMillis, 0L);
    }

    public synchronized long addPeriodic(Runnable toRun, long startTimeMillis, long repeatPeriodMillis) {
        return this.enqueueNewElement(toRun, startTimeMillis, repeatPeriodMillis);
    }

    public synchronized boolean cancel(long id) {
        boolean didCancel = false;
        Iterator<ListElement> iterator = this.queue.iterator();
        while (!didCancel && iterator.hasNext()) {
            ListElement next = iterator.next();
            if (next.id != id) continue;
            iterator.remove();
            didCancel = true;
        }
        return didCancel;
    }

    public synchronized void cancelAll() {
        this.queue.clear();
    }

    private synchronized Runnable getNextRunnable() {
        Runnable toRun = null;
        while (this.threadIsRunning && null == toRun) {
            long millisToSleep = 0L;
            ListElement head = this.queue.peek();
            if (null != head) {
                long now = this.timeSource.currentTimeMillis();
                if (head.startTimeMillis <= now) {
                    toRun = head.toRun;
                    this.queue.remove();
                    if (head.periodTimeMillis > 0L) {
                        ListElement newElement = new ListElement(head.id, head.toRun, head.startTimeMillis + head.periodTimeMillis, head.periodTimeMillis);
                        this.queue.add(newElement);
                    }
                } else {
                    millisToSleep = head.startTimeMillis - now;
                }
            }
            if (null != toRun) continue;
            if (this.isInPoke) {
                this.isInPoke = false;
                this.notifyAll();
            }
            try {
                this.wait(millisToSleep);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getLocalizedMessage());
            }
        }
        return toRun;
    }

    private long enqueueNewElement(Runnable toRun, long startTimeMillis, long repeatPeriodMillis) {
        long id = this.nextId++;
        ListElement element = new ListElement(id, toRun, startTimeMillis, repeatPeriodMillis);
        this.queue.add(element);
        this.notifyAll();
        return id;
    }

    public static interface TimeSource {
        public long currentTimeMillis();
    }

    private static class ListElement {
        public final long id;
        public final Runnable toRun;
        public final long startTimeMillis;
        public final long periodTimeMillis;

        public ListElement(long id, Runnable toRun, long startTimeMillis, long periodTimeMillis) {
            this.id = id;
            this.toRun = toRun;
            this.startTimeMillis = startTimeMillis;
            this.periodTimeMillis = periodTimeMillis;
        }
    }
}

