/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.classloader.BuiltinService;
import com.tc.classloader.ServiceLocator;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.services.DelegatingServiceRegistry;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.services.ToStringStateDumper;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.terracotta.config.TcConfiguration;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.entity.StateDumpable;
import org.terracotta.entity.StateDumper;

public class TerracottaServiceProviderRegistryImpl
implements TerracottaServiceProviderRegistry {
    private static final TCLogger logger = TCLogging.getLogger(TerracottaServiceProviderRegistryImpl.class);
    private final Set<ServiceProvider> serviceProviders = new LinkedHashSet<ServiceProvider>();
    private final Set<ImplementationProvidedServiceProvider> implementationProvidedServiceProviders = new LinkedHashSet<ImplementationProvidedServiceProvider>();
    private boolean hasCreatedSubRegistries;

    @Override
    public void initialize(PlatformConfiguration platformConfiguration, TcConfiguration configuration, ClassLoader loader) {
        List serviceProviderConfigurationList = configuration.getServiceConfigurations();
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        if (serviceProviderConfigurationList != null) {
            for (ServiceProviderConfiguration config : serviceProviderConfigurationList) {
                Class serviceClazz = config.getServiceProviderType();
                try {
                    ServiceProvider provider = (ServiceProvider)serviceClazz.newInstance();
                    if (!provider.initialize(config, platformConfiguration)) continue;
                    this.registerNewServiceProvider(provider);
                }
                catch (IllegalAccessException | InstantiationException ie) {
                    logger.error((Object)("caught exception while initializing service " + serviceClazz), (Throwable)ie);
                    throw new RuntimeException(ie);
                }
            }
        }
        this.loadClasspathBuiltins(loader, platformConfiguration);
    }

    private void loadClasspathBuiltins(ClassLoader loader, PlatformConfiguration platformConfiguration) {
        List<Class<ServiceProvider>> providers = ServiceLocator.getImplementations(ServiceProvider.class, loader);
        for (Class<ServiceProvider> clazz : providers) {
            try {
                if (!clazz.isAnnotationPresent(BuiltinService.class)) {
                    logger.warn((Object)("service:" + clazz.getName() + " is registered as a builtin but is not properly annotated with @BuiltinService.  This builtin will not be loaded"));
                    continue;
                }
                if (!this.serviceProviders.stream().noneMatch(sp -> sp.getClass().getName().equals(clazz.getName()))) continue;
                ServiceProvider service = clazz.newInstance();
                service.initialize(null, platformConfiguration);
                this.registerNewServiceProvider(service);
            }
            catch (IllegalAccessException | InstantiationException i) {
                logger.error((Object)("caught exception while initializing service " + clazz), (Throwable)i);
            }
        }
    }

    @Override
    public void registerExternal(ServiceProvider service) {
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        this.registerNewServiceProvider(service);
    }

    @Override
    public void registerImplementationProvided(ImplementationProvidedServiceProvider service) {
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        logger.info((Object)("Registering implementation-provided service " + service));
        this.implementationProvidedServiceProviders.add(service);
    }

    @Override
    public DelegatingServiceRegistry subRegistry(long consumerID) {
        this.hasCreatedSubRegistries = true;
        return new DelegatingServiceRegistry(consumerID, this.serviceProviders.toArray(new ServiceProvider[this.serviceProviders.size()]), this.implementationProvidedServiceProviders.toArray(new ImplementationProvidedServiceProvider[this.implementationProvidedServiceProviders.size()]));
    }

    @Override
    public void clearServiceProvidersState() {
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            try {
                serviceProvider.prepareForSynchronization();
            }
            catch (ServiceProviderCleanupException e) {
                throw new RuntimeException(e);
            }
        }
        for (ImplementationProvidedServiceProvider builtInServiceProvider : this.implementationProvidedServiceProviders) {
            try {
                builtInServiceProvider.clear();
            }
            catch (ServiceProviderCleanupException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void notifyServerDidBecomeActive() {
        for (ImplementationProvidedServiceProvider builtInServiceProvider : this.implementationProvidedServiceProviders) {
            builtInServiceProvider.serverDidBecomeActive();
        }
    }

    private void registerNewServiceProvider(ServiceProvider service) {
        logger.info((Object)("Initializing " + service));
        this.serviceProviders.add(service);
    }

    public void dumpStateTo(StateDumper stateDumper) {
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            if (!(serviceProvider instanceof StateDumpable)) continue;
            ((StateDumpable)serviceProvider).dumpStateTo(stateDumper.subStateDumper(serviceProvider.getClass().getName()));
        }
        for (ImplementationProvidedServiceProvider implementationProvidedServiceProvider : this.implementationProvidedServiceProviders) {
            if (!(implementationProvidedServiceProvider instanceof StateDumpable)) continue;
            ((StateDumpable)implementationProvidedServiceProvider).dumpStateTo(stateDumper.subStateDumper(implementationProvidedServiceProvider.getClass().getName()));
        }
    }

    public boolean hasUserProvidedServiceProvider(Class<?> serviceInterface) {
        boolean hasProvider = false;
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            if (!serviceProvider.getProvidedServiceTypes().contains(serviceInterface)) continue;
            hasProvider = true;
            break;
        }
        return hasProvider;
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        ToStringStateDumper dump = new ToStringStateDumper("services");
        this.dumpStateTo(dump);
        out.println((Object)dump);
        return out;
    }
}

