/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import java.util.HashMap;
import java.util.Map;
import org.terracotta.entity.StateDumper;

public class ToStringStateDumper
implements StateDumper {
    private final StringBuilder builder = new StringBuilder();
    private final Map<String, ToStringStateDumper> instances = new HashMap<String, ToStringStateDumper>();
    private final Map<String, String> dumpState = new HashMap<String, String>();
    private final String name;

    public ToStringStateDumper(String name) {
        this(name, null);
    }

    public ToStringStateDumper(String name, ToStringStateDumper parent) {
        this.name = parent != null ? parent.getName() + "." + name : name;
    }

    public StateDumper subStateDumper(String name) {
        this.instances.putIfAbsent(name, new ToStringStateDumper(name, this));
        return this.instances.get(name);
    }

    public void dumpState(String key, String value) {
        this.dumpState.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void logState() {
        if (this.dumpState.size() > 0) {
            this.builder.append("\n***********************************************************************************\n");
            this.builder.append(this.name + " state ");
            for (Map.Entry entry : this.dumpState.entrySet()) {
                this.builder.append((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        for (ToStringStateDumper toStringStateDumper : this.instances.values()) {
            toStringStateDumper.logState();
            this.builder.append(toStringStateDumper.toString());
        }
        this.instances.clear();
        this.dumpState.clear();
    }

    public String toString() {
        this.logState();
        return this.builder.toString();
    }
}

