/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.TerracottaOperatorEventsMBean;
import com.tc.management.beans.l1.L1InfoMBean;
import com.tc.net.ClientID;
import com.tc.net.TCSocketAddress;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.net.ChannelStats;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.stats.api.ClientMBean;
import com.tc.stats.counter.Counter;
import com.tc.stats.counter.sampled.SampledCounter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class Client
extends AbstractTerracottaMBean
implements ClientMBean,
NotificationListener {
    private static final TCLogger logger = TCLogging.getLogger(Client.class);
    private final MBeanServer mbeanServer;
    private ObjectName l1InfoBeanName;
    private L1InfoMBean l1InfoBean;
    private ObjectName l1OperatorEventsBeanName;
    private TerracottaOperatorEventsMBean l1OperatorEventsBean;
    private final MessageChannel channel;
    private final SampledCounter txnRate;
    private final SampledCounter writeRate;
    private final SampledCounter readRate;
    private final Counter pendingTransactions;
    private final ClientHandshakeMonitoringInfo minfo;
    private final ClientID clientID;
    private ObjectName enterpriseMBeanName;
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;

    public Client(MBeanServer mbeanServer, MessageChannel channel, ChannelStats channelStats, ClientID clientID) throws NotCompliantMBeanException {
        super(ClientMBean.class, true);
        this.mbeanServer = mbeanServer;
        this.channel = channel;
        this.clientID = clientID;
        this.txnRate = (SampledCounter)channelStats.getCounter(channel, "transactionRate");
        this.writeRate = (SampledCounter)channelStats.getCounter(channel, "writeRate");
        this.readRate = (SampledCounter)channelStats.getCounter(channel, "readRate");
        this.pendingTransactions = channelStats.getCounter(channel, "pendingTransactions");
        this.minfo = (ClientHandshakeMonitoringInfo)channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT);
    }

    public void reset() {
    }

    @Override
    public long getClientID() {
        return this.clientID.toLong();
    }

    @Override
    public String getNodeID() {
        return this.clientID.toString();
    }

    @Override
    public ObjectName getL1InfoBeanName() {
        return this.l1InfoBeanName;
    }

    @Override
    public L1InfoMBean getL1InfoBean() {
        return this.l1InfoBean;
    }

    @Override
    public ObjectName getL1DumperBeanName() {
        return ObjectName.WILDCARD;
    }

    @Override
    public ObjectName getL1OperatorEventsBeanName() {
        return this.l1OperatorEventsBeanName;
    }

    @Override
    public TerracottaOperatorEventsMBean getL1OperatorEventsBean() {
        return this.l1OperatorEventsBean;
    }

    @Override
    public ChannelID getChannelID() {
        return this.channel.getChannelID();
    }

    @Override
    public String getRemoteAddress() {
        TCSocketAddress addr = this.channel.getRemoteAddress();
        if (addr == null) {
            return "not connected";
        }
        return addr.getCanonicalStringForm();
    }

    @Override
    public long getTransactionRate() {
        return this.txnRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getReadRate() {
        return this.readRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getWriteRate() {
        return this.writeRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getPendingTransactionsCount() {
        return this.pendingTransactions.getValue();
    }

    @Override
    public Number[] getStatistics(String[] names) {
        int count = names.length;
        Number[] result = new Number[count];
        for (int i = 0; i < count; ++i) {
            try {
                Method method = this.getClass().getMethod("get" + names[i], new Class[0]);
                result[i] = (Number)method.invoke((Object)this, new Object[0]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void killClient() {
        logger.warn((Object)("Killing Client on JMX Request :" + this.channel));
        this.channel.close();
    }

    @Override
    public int getRemotePID() {
        if (this.minfo != null) {
            return this.minfo.getPid();
        }
        return -1;
    }

    @Override
    public String getRemoteName() {
        if (this.minfo != null) {
            return this.minfo.getName();
        }
        return "";
    }

    @Override
    public String getRemoteUUID() {
        if (this.minfo != null) {
            return this.minfo.getUuid();
        }
        return "";
    }

    private void setupL1InfoBean() {
        this.l1InfoBean = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, this.l1InfoBeanName, L1InfoMBean.class, false);
    }

    private boolean matchesClientBeanName(ObjectName clientBeanName, ObjectName beanName) {
        try {
            ObjectName wildcard = new ObjectName(clientBeanName.getCanonicalName() + ",*");
            return wildcard.apply(beanName);
        }
        catch (MalformedObjectNameException moe) {
            throw new RuntimeException(moe);
        }
    }

    private void beanRegistered(ObjectName beanName) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notification;
            if (type.equals("JMX.mbean.registered")) {
                this.beanRegistered(mbsn.getMBeanName());
            }
        }
    }

    public String getConfig() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getConfig();
    }

    public String getEnvironment() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getEnvironment();
    }

    public Map<String, Object> getStatistics() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getStatistics();
    }

    public String takeThreadDump(long requestMillis) {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.takeThreadDump(requestMillis);
    }

    @Override
    public int getLiveObjectCount() {
        return -1;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return Arrays.asList(NOTIFICATION_INFO).toArray(EMPTY_NOTIFICATION_INFO);
    }

    @Override
    public ObjectName getEnterpriseTCClientBeanName() {
        return this.enterpriseMBeanName;
    }

    static {
        String[] notifTypes = new String[]{};
        String name = Notification.class.getName();
        String description = "DSOClient event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "DSOClient event")};
    }
}

