/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.RemoteManagement;
import com.tc.management.TerracottaManagement;
import com.tc.management.beans.L2MBeanNames;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.object.ObjectID;
import com.tc.object.net.ChannelStats;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.objectserver.api.ObjectInstanceMonitorMBean;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.locks.LockMBean;
import com.tc.objectserver.locks.LockManagerMBean;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventHistoryProvider;
import com.tc.stats.AbstractNotifyingMBean;
import com.tc.stats.Client;
import com.tc.stats.Root;
import com.tc.stats.StatsImpl;
import com.tc.stats.api.ClassInfo;
import com.tc.stats.api.DSOMBean;
import com.tc.stats.api.Stats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class DSO
extends AbstractNotifyingMBean
implements DSOMBean {
    private static final TCLogger logger = TCLogging.getLogger(DSO.class);
    private static final String DSO_OBJECT_NAME_PREFIX = L2MBeanNames.DSO.getCanonicalName() + ",";
    private final StatsImpl dsoStats;
    private final MBeanServer mbeanServer;
    private final List<ObjectName> rootObjectNames = new ArrayList<ObjectName>();
    private final Set<ObjectName> clientObjectNames = new LinkedHashSet<ObjectName>();
    private final Map<ObjectName, Client> clientMap = new HashMap<ObjectName, Client>();
    private final DSOChannelManagerMBean channelMgr;
    private final LockManagerMBean lockMgr;
    private final ChannelStats channelStats;
    private final ObjectInstanceMonitorMBean instanceMonitor;
    private final TerracottaOperatorEventHistoryProvider operatorEventHistoryProvider;
    private final ConnectionPolicy connectionPolicy;
    private final RemoteManagement remoteManagement;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private static final AttributeList EMPTY_ATTR_LIST = new AttributeList();
    private static final Object[] SIMPLE_INVOKE_PARAMS = new Object[0];
    private static final String[] SIMPLE_INVOKE_SIG = new String[0];

    public DSO(ServerManagementContext managementContext, ServerConfigurationContext configContext, MBeanServer mbeanServer, TerracottaOperatorEventHistoryProvider operatorEventHistoryProvider) throws NotCompliantMBeanException {
        super(DSOMBean.class);
        this.mbeanServer = mbeanServer;
        this.dsoStats = new StatsImpl(managementContext);
        this.lockMgr = managementContext.getLockManager();
        this.channelMgr = managementContext.getChannelManager();
        this.channelStats = managementContext.getChannelStats();
        this.instanceMonitor = managementContext.getInstanceMonitor();
        this.operatorEventHistoryProvider = operatorEventHistoryProvider;
        this.connectionPolicy = managementContext.getConnectionPolicy();
        this.remoteManagement = managementContext.getRemoteManagement();
        this.channelMgr.addEventListener((DSOChannelManagerEventListener)new ChannelManagerListener());
        this.setupClients();
    }

    public void reset() {
    }

    @Override
    public Stats getStats() {
        return this.dsoStats;
    }

    @Override
    public long getTransactionRate() {
        return this.getStats().getTransactionRate();
    }

    @Override
    public long getReadOperationRate() {
        return this.getStats().getReadOperationRate();
    }

    @Override
    public long getGlobalLockRecallRate() {
        return this.getStats().getGlobalLockRecallRate();
    }

    @Override
    public long getTransactionSizeRate() {
        return this.getStats().getTransactionSizeRate();
    }

    @Override
    public long getBroadcastRate() {
        return this.getStats().getBroadcastRate();
    }

    @Override
    public Number[] getStatistics(String[] names) {
        return this.getStats().getStatistics(names);
    }

    @Override
    public List<TerracottaOperatorEvent> getOperatorEvents() {
        return this.operatorEventHistoryProvider.getOperatorEvents();
    }

    @Override
    public List<TerracottaOperatorEvent> getOperatorEvents(long sinceTimestamp) {
        return this.operatorEventHistoryProvider.getOperatorEvents(sinceTimestamp);
    }

    @Override
    public boolean markOperatorEvent(TerracottaOperatorEvent operatorEvent, boolean read) {
        return this.operatorEventHistoryProvider.markOperatorEvent(operatorEvent, read);
    }

    @Override
    public Map<String, Integer> getUnreadOperatorEventCount() {
        return this.operatorEventHistoryProvider.getUnreadCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName[] getRoots() {
        List<ObjectName> list = this.rootObjectNames;
        synchronized (list) {
            return this.rootObjectNames.toArray(new ObjectName[this.rootObjectNames.size()]);
        }
    }

    @Override
    public LockMBean[] getLocks() {
        return this.lockMgr != null ? this.lockMgr.getAllLocks() : new LockMBean[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName[] getClients() {
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            return this.clientObjectNames.toArray(new ObjectName[this.clientObjectNames.size()]);
        }
    }

    @Override
    public ClassInfo[] getClassInfo() {
        Map<String, Integer> counts = this.instanceMonitor.getInstanceCounts();
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            list.add(new ClassInfo(entry.getKey(), entry.getValue()));
        }
        return list.toArray(new ClassInfo[list.size()]);
    }

    private void setupClients() {
        MessageChannel[] channels;
        for (MessageChannel channel : channels = this.channelMgr.getActiveChannels()) {
            this.addClientMBean(channel);
        }
    }

    private ObjectName makeClientObjectName(MessageChannel channel) {
        try {
            return TerracottaManagement.createObjectName((TerracottaManagement.Type)TerracottaManagement.Type.Client, (TerracottaManagement.Subsystem)TerracottaManagement.Subsystem.None, null, (String)(channel.getProductId().toString() + "" + channel.getChannelID().toLong()), (TerracottaManagement.MBeanDomain)TerracottaManagement.MBeanDomain.PUBLIC);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName makeRootObjectName(String name, ObjectID id) {
        try {
            return new ObjectName(DSO_OBJECT_NAME_PREFIX + "rootID=" + id.toLong());
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRootMBean(String name, ObjectID rootID) {
        if (name.startsWith("@")) {
            return;
        }
        List<ObjectName> list = this.rootObjectNames;
        synchronized (list) {
            ObjectName rootName = this.makeRootObjectName(name, rootID);
            if (this.mbeanServer.isRegistered(rootName)) {
                logger.debug((Object)("Root MBean already registered for name " + rootName));
                return;
            }
            try {
                Root dsoRoot = new Root(rootID, name);
                this.mbeanServer.registerMBean(dsoRoot, rootName);
                this.rootObjectNames.add(rootName);
                this.sendNotification("dso.root.added", rootName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientMBean(MessageChannel channel) {
        ObjectName clientName = this.makeClientObjectName(channel);
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            try {
                if (this.mbeanServer.isRegistered(clientName)) {
                    this.sendNotification("dso.client.detached", clientName);
                    this.mbeanServer.unregisterMBean(clientName);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                this.clientObjectNames.remove(clientName);
                Client client = this.clientMap.remove(clientName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientMBean(MessageChannel channel) {
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            ObjectName clientName = this.makeClientObjectName(channel);
            if (this.mbeanServer.isRegistered(clientName)) {
                logger.debug((Object)("channel MBean already registered for name " + clientName));
                return;
            }
            try {
                Client client = new Client(this.mbeanServer, channel, this.channelStats, this.channelMgr.getClientIDFor(channel.getChannelID()));
                this.mbeanServer.registerMBean(client, clientName);
                this.clientObjectNames.add(clientName);
                this.clientMap.put(clientName, client);
                this.sendNotification("dso.client.attached", clientName);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to register terracotta client MBean", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, Long> getAllPendingTransactionsCount() {
        HashMap<ObjectName, Long> map = new HashMap<ObjectName, Long>();
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                map.put(clientBeanName, this.clientMap.get(clientBeanName).getPendingTransactionsCount());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPendingTransactionsCount() {
        long result = 0L;
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                result += this.clientMap.get(clientBeanName).getPendingTransactionsCount();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, Long> getClientTransactionRates() {
        HashMap<ObjectName, Long> result = new HashMap<ObjectName, Long>();
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                result.put(clientBeanName, this.clientMap.get(clientBeanName).getTransactionRate());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, Map<String, Object>> getL1Statistics() {
        HashMap<ObjectName, Map<String, Object>> result = new HashMap<ObjectName, Map<String, Object>>();
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                result.put(clientBeanName, this.clientMap.get(clientBeanName).getStatistics());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, Map<String, Object>> getPrimaryClientStatistics() {
        HashMap<ObjectName, Map<String, Object>> result = new HashMap<ObjectName, Map<String, Object>>();
        ArrayList<PrimaryClientStatWorker> tasks = new ArrayList<PrimaryClientStatWorker>();
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                tasks.add(new PrimaryClientStatWorker(clientBeanName, this.clientMap.get(clientBeanName)));
            }
        }
        try {
            List results = pool.invokeAll(tasks, 2L, TimeUnit.SECONDS);
            for (Future future : results) {
                if (!future.isDone()) continue;
                try {
                    Map statsMap = (Map)future.get();
                    if (statsMap == null) continue;
                    result.put((ObjectName)statsMap.remove("clientBeanName"), statsMap);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int getLiveObjectCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, Integer> getClientLiveObjectCount() {
        HashMap<ObjectName, Integer> result = new HashMap<ObjectName, Integer>();
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            for (ObjectName clientBeanName : this.clientObjectNames) {
                result.put(clientBeanName, this.clientMap.get(clientBeanName).getLiveObjectCount());
            }
        }
        return result;
    }

    @Override
    public long getGlobalServerMapGetSizeRequestsCount() {
        return this.getStats().getGlobalServerMapGetSizeRequestsCount();
    }

    @Override
    public long getGlobalServerMapGetSizeRequestsRate() {
        return this.getStats().getGlobalServerMapGetSizeRequestsRate();
    }

    @Override
    public long getGlobalServerMapGetValueRequestsCount() {
        return this.getStats().getGlobalServerMapGetValueRequestsCount();
    }

    @Override
    public long getGlobalServerMapGetValueRequestsRate() {
        return this.getStats().getGlobalServerMapGetValueRequestsRate();
    }

    @Override
    public long getWriteOperationRate() {
        return this.getStats().getWriteOperationRate();
    }

    private static Exception newPlainException(Exception e) {
        String type = e.getClass().getName();
        if (type.startsWith("java.") || type.startsWith("javax.")) {
            return e;
        }
        RuntimeException result = new RuntimeException(e.getMessage());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    @Override
    public Map<ObjectName, Exception> setAttribute(Set<ObjectName> onSet, String attrName, Object attrValue) {
        HashMap<ObjectName, Exception> result = new HashMap<ObjectName, Exception>();
        Iterator<ObjectName> onIter = onSet.iterator();
        Attribute attribute = new Attribute(attrName, attrValue);
        while (onIter.hasNext()) {
            ObjectName on = onIter.next();
            try {
                this.mbeanServer.setAttribute(on, attribute);
            }
            catch (Exception e) {
                result.put(on, DSO.newPlainException(e));
            }
        }
        return result;
    }

    @Override
    public Map<ObjectName, Exception> setAttribute(String attrName, Map<ObjectName, Object> attrMap) {
        HashMap<ObjectName, Exception> result = new HashMap<ObjectName, Exception>();
        for (Map.Entry<ObjectName, Object> entry : attrMap.entrySet()) {
            ObjectName on = entry.getKey();
            try {
                Attribute attribute = new Attribute(attrName, entry.getValue());
                this.mbeanServer.setAttribute(on, attribute);
            }
            catch (Exception e) {
                result.put(on, DSO.newPlainException(e));
            }
        }
        return result;
    }

    @Override
    public Map<ObjectName, Map<String, Object>> getAttributeMap(Map<ObjectName, Set<String>> attributeMap, long timeout, TimeUnit unit) {
        HashMap<ObjectName, Map<String, Object>> result = new HashMap<ObjectName, Map<String, Object>>();
        ArrayList<AttributeListTask> tasks = new ArrayList<AttributeListTask>();
        for (Map.Entry<ObjectName, Set<String>> entry : attributeMap.entrySet()) {
            tasks.add(new AttributeListTask(entry.getKey(), entry.getValue()));
        }
        try {
            List results = pool.invokeAll(tasks, timeout, unit);
            for (Future future : results) {
                if (!future.isDone() || future.isCancelled()) continue;
                try {
                    SourcedAttributeList sal = (SourcedAttributeList)future.get();
                    Iterator attrIter = sal.attributeList.iterator();
                    HashMap<String, Object> onMap = new HashMap<String, Object>();
                    while (attrIter.hasNext()) {
                        Attribute attr = (Attribute)attrIter.next();
                        onMap.put(attr.getName(), attr.getValue());
                    }
                    result.put(sal.objectName, onMap);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Map<ObjectName, Object> invoke(Set<ObjectName> onSet, String operation, long timeout, TimeUnit unit) {
        return this.invoke(onSet, operation, timeout, unit, SIMPLE_INVOKE_PARAMS, SIMPLE_INVOKE_SIG);
    }

    @Override
    public Map<ObjectName, Object> invoke(Set<ObjectName> onSet, String operation, long timeout, TimeUnit unit, Object[] args, String[] sigs) {
        HashMap<ObjectName, Object> result = new HashMap<ObjectName, Object>();
        ArrayList<SimpleInvokeTask> tasks = new ArrayList<SimpleInvokeTask>();
        Iterator<ObjectName> onIter = onSet.iterator();
        while (onIter.hasNext()) {
            tasks.add(new SimpleInvokeTask(onIter.next(), operation, args, sigs));
        }
        try {
            List results = pool.invokeAll(tasks, timeout, unit);
            for (Future future : results) {
                if (!future.isDone() || future.isCancelled()) continue;
                try {
                    SimpleInvokeResult sir = (SimpleInvokeResult)future.get();
                    result.put(sir.objectName, sir.result);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int getActiveLicensedClientCount() {
        return this.connectionPolicy.getNumberOfActiveConnections();
    }

    @Override
    public int getLicensedClientHighCount() {
        return this.connectionPolicy.getConnectionHighWatermark();
    }

    @Override
    public RemoteManagement getRemoteManagement() {
        return this.remoteManagement;
    }

    private class SimpleInvokeTask
    implements Callable<SimpleInvokeResult> {
        private final ObjectName objectName;
        private final String operation;
        private final Object[] arguments;
        private final String[] signatures;

        SimpleInvokeTask(ObjectName objectName, String operation, Object[] arguments, String[] signatures) {
            this.objectName = objectName;
            this.operation = operation;
            this.arguments = arguments;
            this.signatures = signatures;
        }

        @Override
        public SimpleInvokeResult call() {
            Object result;
            try {
                result = DSO.this.mbeanServer.invoke(this.objectName, this.operation, this.arguments, this.signatures);
            }
            catch (Exception e) {
                result = e;
            }
            return new SimpleInvokeResult(this.objectName, result);
        }
    }

    private static class SimpleInvokeResult {
        final ObjectName objectName;
        final Object result;

        private SimpleInvokeResult(ObjectName objectName, Object result) {
            this.objectName = objectName;
            this.result = result;
        }
    }

    private class AttributeListTask
    implements Callable<SourcedAttributeList> {
        private final ObjectName objectName;
        private final Set<String> attributeSet;

        AttributeListTask(ObjectName objectName, Set<String> attributeSet) {
            this.objectName = objectName;
            this.attributeSet = attributeSet;
        }

        @Override
        public SourcedAttributeList call() {
            AttributeList attributeList;
            try {
                attributeList = DSO.this.mbeanServer.getAttributes(this.objectName, this.attributeSet.toArray(new String[0]));
            }
            catch (Exception e) {
                attributeList = EMPTY_ATTR_LIST;
            }
            return new SourcedAttributeList(this.objectName, attributeList);
        }
    }

    private static class SourcedAttributeList {
        final ObjectName objectName;
        final AttributeList attributeList;

        private SourcedAttributeList(ObjectName objectName, AttributeList attributeList) {
            this.objectName = objectName;
            this.attributeList = attributeList;
        }
    }

    private class ChannelManagerListener
    implements DSOChannelManagerEventListener {
        private ChannelManagerListener() {
        }

        public void channelCreated(MessageChannel channel) {
            DSO.this.addClientMBean(channel);
        }

        public void channelRemoved(MessageChannel channel, boolean wasActive) {
            DSO.this.removeClientMBean(channel);
        }
    }

    private static class PrimaryClientStatWorker
    implements Callable<Map<String, Object>> {
        private final ObjectName clientBeanName;
        private final Client client;

        private PrimaryClientStatWorker(ObjectName clientBeanName, Client client) {
            this.clientBeanName = clientBeanName;
            this.client = client;
        }

        @Override
        public Map<String, Object> call() {
            try {
                Map<String, Object> result = this.client.getStatistics();
                if (result != null) {
                    result.put("TransactionRate", this.client.getTransactionRate());
                    result.put("clientBeanName", this.clientBeanName);
                }
                return result;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

