/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.objectserver.core.api.GlobalServerStats;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.stats.api.Stats;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.derived.SampledRateCounter;
import java.lang.reflect.Method;

public class StatsImpl
implements Stats {
    private final GlobalServerStats serverStats;
    private final SampledCounter faultRate;
    private final SampledCounter txnRate;
    private final SampledCounter globalLockRecallRate;
    private final SampledRateCounter transactionSizeRate;
    private final SampledCounter broadcastRate;

    public StatsImpl(ServerManagementContext context) {
        this.serverStats = context.getServerStats();
        this.faultRate = this.serverStats.getReadOperationRateCounter();
        this.txnRate = this.serverStats.getTransactionCounter();
        this.globalLockRecallRate = this.serverStats.getGlobalLockRecallCounter();
        this.transactionSizeRate = this.serverStats.getTransactionSizeCounter();
        this.broadcastRate = this.serverStats.getBroadcastCounter();
    }

    @Override
    public long getReadOperationRate() {
        return this.faultRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getTransactionRate() {
        return this.txnRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getGlobalLockRecallRate() {
        return this.globalLockRecallRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getTransactionSizeRate() {
        return this.transactionSizeRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getBroadcastRate() {
        return this.broadcastRate.getMostRecentSample().getCounterValue();
    }

    @Override
    public Number[] getStatistics(String[] names) {
        int count = names.length;
        Number[] result = new Number[count];
        for (int i = 0; i < count; ++i) {
            try {
                Method method = this.getClass().getMethod("get" + names[i], new Class[0]);
                result[i] = (Number)method.invoke((Object)this, new Object[0]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public long getGlobalServerMapGetSizeRequestsCount() {
        return this.serverStats.getServerMapGetSizeRequestsCounter().getCumulativeValue();
    }

    @Override
    public long getGlobalServerMapGetSizeRequestsRate() {
        return this.serverStats.getServerMapGetSizeRequestsCounter().getMostRecentSample().getCounterValue();
    }

    @Override
    public long getGlobalServerMapGetValueRequestsCount() {
        return this.serverStats.getServerMapGetValueRequestsCounter().getCumulativeValue();
    }

    @Override
    public long getGlobalServerMapGetValueRequestsRate() {
        return this.serverStats.getServerMapGetValueRequestsCounter().getMostRecentSample().getCounterValue();
    }

    @Override
    public long getWriteOperationRate() {
        return this.serverStats.getOperationCounter().getMostRecentSample().getCounterValue();
    }
}

