/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.stats.statistics.Statistic;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;

public class StatsSupport
extends NotificationBroadcasterSupport
implements Serializable {
    private final Map<String, Statistic> statMap = new HashMap<String, Statistic>();
    private final AtomicLong sequenceNumber = new AtomicLong();

    public synchronized void addStatistic(String id, Statistic statistic) {
        this.statMap.put(id, statistic);
    }

    public synchronized Statistic getStatistic(String id) {
        return this.statMap.get(id);
    }

    public synchronized String[] getStatisticNames() {
        return this.statMap.keySet().toArray(new String[this.statMap.size()]);
    }

    public synchronized Statistic[] getStatistics() {
        return this.statMap.values().toArray(new Statistic[this.statMap.size()]);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, name, description)};
    }

    protected void sendNotification(String msg, String attr, String type, Object oldVal, Object newVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber.getAndIncrement(), System.currentTimeMillis(), msg, attr, type, oldVal, newVal));
    }
}

