/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.config.schema.ActiveServerGroupConfigObject;
import com.tc.config.schema.setup.ConfigurationSetupException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class ActiveCoordinatorHelper {
    public static final String GROUP_NAME_PREFIX = "Tc-Group-";

    public static ActiveServerGroupConfigObject[] generateGroupInfo(ActiveServerGroupConfigObject[] originalGroupInfos) throws ConfigurationSetupException {
        TreeMap<String, ActiveServerGroupConfigObject> candidateGroupNames = ActiveCoordinatorHelper.generateCandidateGroupNames(originalGroupInfos);
        if (originalGroupInfos.length != candidateGroupNames.size()) {
            throw new ConfigurationSetupException("The group names specified are same " + candidateGroupNames.keySet());
        }
        ActiveServerGroupConfigObject[] groupInfos = new ActiveServerGroupConfigObject[originalGroupInfos.length];
        int groupID = 0;
        for (Map.Entry<String, ActiveServerGroupConfigObject> entry : candidateGroupNames.entrySet()) {
            ActiveServerGroupConfigObject groupInfo = entry.getValue();
            if (ActiveCoordinatorHelper.groupNameNotSet(groupInfo)) {
                groupInfo.setGroupName(GROUP_NAME_PREFIX + groupID);
            }
            groupInfos[groupID] = groupInfo;
            ++groupID;
        }
        return groupInfos;
    }

    private static TreeMap<String, ActiveServerGroupConfigObject> generateCandidateGroupNames(ActiveServerGroupConfigObject[] asgcos) {
        TreeMap<String, ActiveServerGroupConfigObject> groupNamesToGroup = new TreeMap<String, ActiveServerGroupConfigObject>();
        for (ActiveServerGroupConfigObject asgco : asgcos) {
            String groupName = null;
            groupName = ActiveCoordinatorHelper.groupNameNotSet(asgco) ? ActiveCoordinatorHelper.getGroupNameFrom(asgco.getMembers()) : asgco.getGroupName();
            groupNamesToGroup.put(groupName, asgco);
        }
        return groupNamesToGroup;
    }

    private static boolean groupNameNotSet(ActiveServerGroupConfigObject asgco) {
        return asgco.getGroupName() == null || asgco.getGroupName() == "";
    }

    private static String getGroupNameFrom(String[] members) {
        Object[] temp = new String[members.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = members[i];
        }
        Arrays.sort(temp);
        StringBuffer groupName = new StringBuffer();
        for (Object element : temp) {
            groupName.append((String)element);
        }
        return groupName.toString();
    }
}

