/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.object.config.schema.L2ConfigObject;
import com.tc.sysinfo.EnvStats;
import com.tc.util.ZipBuilder;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;
import org.terracotta.config.TCConfigurationParser;
import org.terracotta.config.TcConfig;
import org.xml.sax.SAXException;

public final class ArchiveUtil {
    private final boolean isClient;
    private final File tcConfig;
    private final File archiveFile;
    private static final String STDOUT = "stdout:";
    private static final String STDERR = "stderr:";
    private static final String ARCHIVE_FILE_NAME = "tc-archive";
    private static final String INVALID = "Invalid Arguments:\n\n";
    private static final String DASH_C = "-c";
    private static final String USAGE = "** Terracotta Archive Tool **\n\nA utility for archiving Terracotta environment information.\n\n\tValid Arguments are:\n\n\t[-c] (Client - include files from the terracotta client)\n\t<path to terracotta config xml file (tc-config.xml)> | <path to logs directory>\n\t[<output filename in .zip format>]\n\nExamples:\n\n\t# java " + ArchiveUtil.class.getName() + " tc-config.xml /home/someuser/tc-archive_server.zip\n\tor\n\t# java " + ArchiveUtil.class.getName() + " /export1/terracotta/server-logs\n\nUsage Summary:\n\n\tTypically you will use this tool to create an archive of the Terracotta server logs.\n\tYou may also want to create archives on the terracotta client machines using the -c option.\n\tThere are two scenarios where you may need to use the directory location instead of the config file path.\n\n\t\t1. The terracotta client may not have a local copy of the tc-config.xml\n\t\t2. The tc-config.xml logs elements may contain wildcards which use timestamps or \n\t\t   environment variables which cannot be resolved.\n\nNotes:\n\n\tThe execution command may vary:\n\t\t# ./archive-util ...\n\n\tSpecifying a directory location as the first command will recursively archive it's entire contents";
    private static final Set<String> validDashArgs = new HashSet<String>();

    private ArchiveUtil(boolean isClient, File archivePath, File fileName) {
        this.isClient = isClient;
        this.tcConfig = archivePath;
        if (fileName == null) {
            File userDir = new File(System.getProperty("user.dir"));
            if (!userDir.exists()) {
                throw new RuntimeException("Unexpected error - system property user.dir does not resolve to an actual directory: " + userDir);
            }
            SimpleDateFormat df = new SimpleDateFormat("y-M-d");
            String name = "tc-archive_" + df.format(new Date(System.currentTimeMillis())) + ".zip";
            this.archiveFile = new File(userDir + File.separator + name);
        } else {
            this.archiveFile = fileName;
        }
    }

    private static void quit(String msg) {
        System.err.println(msg);
        System.exit(0);
    }

    private static void escape(String msg, Exception e) {
        System.out.println(INVALID + msg);
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        File tcConfigFile;
        if (args.length < 1) {
            ArchiveUtil.escape(USAGE, null);
        }
        boolean dashArgs = true;
        int locationCmd = -1;
        int fileArg = -1;
        HashSet<String> dashSet = new HashSet<String>(2);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (!dashArgs) {
                    ArchiveUtil.escape(USAGE, null);
                }
                if (validDashArgs.contains(args[i])) {
                    dashSet.add(args[i]);
                    continue;
                }
                ArchiveUtil.escape(USAGE, null);
                continue;
            }
            dashArgs = false;
            if (fileArg + locationCmd > 1) {
                ArchiveUtil.escape(USAGE, null);
            }
            if (locationCmd < 0) {
                locationCmd = i;
            } else if (fileArg < 0) {
                fileArg = i;
            }
            if (fileArg + locationCmd != -2) continue;
            ArchiveUtil.escape(USAGE, null);
        }
        if (dashSet.size() > 2) {
            ArchiveUtil.escape(USAGE, null);
        }
        boolean dashC = dashSet.contains(DASH_C);
        if (locationCmd < 0) {
            ArchiveUtil.escape("Please specify the Terracotta config file location or logs directory location\n\n" + USAGE, null);
        }
        if (!(tcConfigFile = new File(args[locationCmd])).exists()) {
            ArchiveUtil.escape("\tTerracotta Configuration file: " + tcConfigFile + "\n\tdoes not exist\n\n" + USAGE, null);
        }
        File outputFile = null;
        if (fileArg > 0 && !new File((outputFile = new File(new File(args[fileArg]).getAbsolutePath())).getParent()).exists()) {
            ArchiveUtil.escape("\tThe directory specified for the output file does not exist", null);
        }
        try {
            new ArchiveUtil(dashC, tcConfigFile, outputFile).createArchive();
        }
        catch (IOException e) {
            ArchiveUtil.escape("\tUnable to read Terracotta configuration file\n", e);
        }
        catch (SAXException e) {
            ArchiveUtil.escape("\tUnable to parse Terracotta configuration file\n", e);
        }
    }

    private File makeAbsolute(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.tcConfig.getParent() + File.separator + file);
    }

    private File getClientLogsLocation(TcConfig configBeans) {
        return null;
    }

    private boolean isStdX(String value) {
        if (value == null) {
            return false;
        }
        return value.equals(STDOUT) || value.equals(STDERR);
    }

    private Server[] getServersElement(TcConfig configBeans) {
        Servers servers = configBeans.getServers();
        if (servers == null) {
            ArchiveUtil.quit("The Terracotta config specified doesn't contain the <servers> element");
        }
        return L2ConfigObject.getServers(servers);
    }

    private File[] getServerLogsLocation(TcConfig configBeans) {
        Server[] servers = this.getServersElement(configBeans);
        String[] logs = new String[servers.length];
        File[] logFiles = new File[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            File serverLogsDir;
            logs[i] = servers[i].getLogs();
            if (this.isStdX(logs[i])) {
                logs[i] = null;
            }
            if (!(serverLogsDir = this.makeAbsolute(new File(logs[i]))).exists()) {
                ArchiveUtil.quit("\nError occured while parsing: " + this.tcConfig + "\n\tUnable to resolve the server log location element to an actual file: " + logs[i]);
            }
            logFiles[i] = serverLogsDir;
        }
        return logFiles;
    }

    private void createPathArchive() {
        try {
            System.out.println("Archiving:\n----------------------------------------");
            ZipBuilder zip = new ZipBuilder(this.archiveFile, true);
            zip.putEntry("env-stats", EnvStats.report().getBytes("UTF-8"));
            zip.putTraverseDirectory(this.tcConfig, this.tcConfig.getName());
            zip.finish();
        }
        catch (IOException e) {
            System.out.println("Unexpected error - unable to write Terracotta archive: " + this.archiveFile);
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("\n\nWrote archive to:" + this.archiveFile);
    }

    private void createArchive() throws IOException, SAXException {
        if (this.tcConfig.isDirectory()) {
            this.createPathArchive();
            return;
        }
        TcConfig configBeans = TCConfigurationParser.parse((File)this.tcConfig, (ClassLoader)this.tcConfig.getClass().getClassLoader()).getPlatformConfiguration();
        File clientLogsDir = null;
        File[] serverLogsDir = null;
        if (this.isClient) {
            clientLogsDir = this.getClientLogsLocation(configBeans);
        } else {
            serverLogsDir = this.getServerLogsLocation(configBeans);
        }
        try {
            ZipBuilder zip = new ZipBuilder(this.archiveFile, true);
            System.out.println("Archiving:");
            zip.putEntry(this.tcConfig.getName(), zip.readFile(this.tcConfig));
            if (this.isClient) {
                if (clientLogsDir != null) {
                    zip.putTraverseDirectory(clientLogsDir, clientLogsDir.getName());
                }
            } else {
                for (File element : serverLogsDir) {
                    if (element == null) continue;
                    zip.putTraverseDirectory(element, element.getName());
                }
            }
            zip.finish();
        }
        catch (IOException e) {
            System.out.println("Unexpected error - unable to write Terracotta archive: " + this.archiveFile);
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("\n\nWrote archive to:" + this.archiveFile);
    }

    static {
        validDashArgs.add(DASH_C);
    }
}

