/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.object.ObjectID;
import com.tc.objectserver.api.Transaction;
import com.tc.util.OidBitsArrayMap;
import com.tc.util.OidLongArray;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class OidBitsArrayMapImpl
implements OidBitsArrayMap {
    protected final SortedMap<Long, OidLongArray> map;
    protected final int bitsLength;
    protected final int longsPerDiskUnit;

    public OidBitsArrayMapImpl(int longsPerDiskUnit) {
        this.longsPerDiskUnit = longsPerDiskUnit;
        this.bitsLength = longsPerDiskUnit * 64;
        this.map = new TreeMap<Long, OidLongArray>();
    }

    public Long oidIndex(ObjectID id) {
        return this.oidIndex(id.toLong());
    }

    public Long oidIndex(long oid) {
        long idx = oid / (long)this.bitsLength * (long)this.bitsLength;
        if (oid < 0L && oid % (long)this.bitsLength != 0L) {
            idx -= (long)this.bitsLength;
        }
        return idx;
    }

    public OidLongArray getBitsArray(long oid) {
        return (OidLongArray)this.map.get(this.oidIndex(oid));
    }

    private OidLongArray getOrLoadBitsArray(long oid, Transaction tx) {
        Long mapIndex = this.oidIndex(oid);
        OidLongArray longAry = (OidLongArray)this.map.get(mapIndex);
        if (longAry == null) {
            longAry = this.loadArray(oid, this.longsPerDiskUnit, mapIndex, tx);
        }
        this.map.put(mapIndex, longAry);
        return longAry;
    }

    protected OidLongArray loadArray(long oid, int lPerDiskUnit, long mapIndex, Transaction tx) {
        return new OidLongArray(lPerDiskUnit, mapIndex);
    }

    private int arrayOffset(long oid) {
        return (int)(Math.abs(oid) % (long)this.bitsLength);
    }

    private OidLongArray getAndModify(long oid, boolean doSet, Transaction tx) {
        OidLongArray longAry = this.getOrLoadBitsArray(oid, tx);
        int oidInArray = this.arrayOffset(oid);
        if (doSet) {
            longAry.setBit(oidInArray);
        } else {
            longAry.clrBit(oidInArray);
        }
        return longAry;
    }

    @Override
    public OidLongArray getAndSet(ObjectID id, Transaction tx) {
        return this.getAndModify(id.toLong(), true, tx);
    }

    @Override
    public OidLongArray getAndClr(ObjectID id, Transaction tx) {
        return this.getAndModify(id.toLong(), false, tx);
    }

    @Override
    public boolean contains(ObjectID id) {
        long oid = id.toLong();
        Long mapIndex = this.oidIndex(oid);
        if (this.map.containsKey(mapIndex)) {
            OidLongArray longAry = (OidLongArray)this.map.get(mapIndex);
            return longAry.isSet(this.arrayOffset(oid));
        }
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<Long, OidLongArray> entry : this.map.entrySet()) {
            Long base = entry.getKey();
            OidLongArray ary = entry.getValue();
            for (int i = 0; i < ary.totalBits(); ++i) {
                if (!ary.isSet(i)) continue;
                buf.append(" " + (base + (long)i));
            }
        }
        return buf.toString();
    }
}

