/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.lock.server;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.ehcache.clustered.common.internal.lock.LockMessaging;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveSynchronizationChannel;

class VoltronReadWriteLockActiveEntity
implements ActiveServerEntity<LockMessaging.LockOperation, LockMessaging.LockTransition> {
    private final ClientCommunicator communicator;
    private final Set<ClientDescriptor> releaseListeners = new CopyOnWriteArraySet<ClientDescriptor>();
    private final Set<ClientDescriptor> sharedHolders = new CopyOnWriteArraySet<ClientDescriptor>();
    private ClientDescriptor exclusiveHolder;

    public VoltronReadWriteLockActiveEntity(ClientCommunicator communicator) {
        this.communicator = communicator;
    }

    public LockMessaging.LockTransition invoke(ClientDescriptor client, LockMessaging.LockOperation message) {
        switch (message.getOperation()) {
            case TRY_ACQUIRE: {
                return this.tryAcquire(client, message.getHoldType());
            }
            case ACQUIRE: {
                return this.acquire(client, message.getHoldType());
            }
            case RELEASE: {
                return this.release(client, message.getHoldType());
            }
        }
        throw new AssertionError();
    }

    public void connected(ClientDescriptor client) {
    }

    public void disconnected(ClientDescriptor client) {
        this.releaseListeners.remove(client);
        if (client.equals(this.exclusiveHolder)) {
            this.release(client, LockMessaging.HoldType.WRITE);
        } else if (this.sharedHolders.contains(client)) {
            this.release(client, LockMessaging.HoldType.READ);
        }
    }

    public void handleReconnect(ClientDescriptor client, byte[] reconnectData) {
        if (reconnectData.length == 0) {
            this.releaseListeners.add(client);
        } else {
            try {
                if (!this.invoke(client, (LockMessaging.LockOperation)LockMessaging.codec().decodeMessage(reconnectData)).isAcquired()) {
                    throw new IllegalStateException("Unexpected lock acquisition failure during reconnect");
                }
            }
            catch (MessageCodecException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<LockMessaging.LockOperation> syncChannel, int concurrencyKey) {
    }

    private LockMessaging.LockTransition tryAcquire(ClientDescriptor client, LockMessaging.HoldType holdType) {
        if (this.exclusiveHolder != null) {
            return LockMessaging.empty();
        }
        switch (holdType) {
            case READ: {
                this.sharedHolders.add(client);
                return this.acquired(client);
            }
            case WRITE: {
                if (this.sharedHolders.isEmpty()) {
                    this.exclusiveHolder = client;
                    return this.acquired(client);
                }
                return LockMessaging.empty();
            }
        }
        throw new AssertionError();
    }

    private LockMessaging.LockTransition acquire(ClientDescriptor client, LockMessaging.HoldType holdType) {
        if (this.exclusiveHolder != null) {
            return this.waiting(client);
        }
        switch (holdType) {
            case READ: {
                this.sharedHolders.add(client);
                return this.acquired(client);
            }
            case WRITE: {
                if (this.sharedHolders.isEmpty()) {
                    this.exclusiveHolder = client;
                    return this.acquired(client);
                }
                return this.waiting(client);
            }
        }
        throw new AssertionError();
    }

    private LockMessaging.LockTransition release(ClientDescriptor client, LockMessaging.HoldType holdType) {
        switch (holdType) {
            case READ: {
                if (this.sharedHolders.remove(client)) {
                    if (this.sharedHolders.isEmpty()) {
                        this.notifyReleaseListeners();
                    }
                    return LockMessaging.released();
                }
                return LockMessaging.empty();
            }
            case WRITE: {
                if (client.equals(this.exclusiveHolder)) {
                    this.exclusiveHolder = null;
                    this.notifyReleaseListeners();
                    return LockMessaging.released();
                }
                return LockMessaging.empty();
            }
        }
        throw new AssertionError();
    }

    public void createNew() {
    }

    public void loadExisting() {
    }

    public void destroy() {
    }

    private LockMessaging.LockTransition acquired(ClientDescriptor client) {
        this.releaseListeners.remove(client);
        return LockMessaging.acquired();
    }

    private LockMessaging.LockTransition waiting(ClientDescriptor client) {
        this.releaseListeners.add(client);
        return LockMessaging.empty();
    }

    private void notifyReleaseListeners() {
        for (ClientDescriptor client : this.releaseListeners) {
            try {
                this.communicator.sendNoResponse(client, (EntityResponse)LockMessaging.released());
            }
            catch (MessageCodecException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

