/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.InvalidClientIdException;
import org.ehcache.clustered.common.internal.exceptions.InvalidOperationException;
import org.ehcache.clustered.common.internal.exceptions.LifecycleException;
import org.ehcache.clustered.common.internal.messages.ClusterTierManagerReconnectMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponseFactory;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ReconnectMessageCodec;
import org.ehcache.clustered.server.ClientState;
import org.ehcache.clustered.server.management.Management;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;

public class ClusterTierManagerActiveEntity
implements ActiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerActiveEntity.class);
    private final Map<ClientDescriptor, ClientState> clientStateMap = new ConcurrentHashMap<ClientDescriptor, ClientState>();
    private final ReconnectMessageCodec reconnectMessageCodec = new ReconnectMessageCodec();
    private final EhcacheEntityResponseFactory responseFactory;
    private final EhcacheStateService ehcacheStateService;
    private final IEntityMessenger entityMessenger;
    private final Management management;
    private final AtomicBoolean reconnectComplete = new AtomicBoolean(true);
    private final ServerSideConfiguration configuration;

    public ClusterTierManagerActiveEntity(ServiceRegistry services, ClusterTierManagerConfiguration config, EhcacheStateService ehcacheStateService, Management management) throws ConfigurationException {
        if (config == null) {
            throw new ConfigurationException("ClusterTierManagerConfiguration cannot be null");
        }
        this.configuration = config.getConfiguration();
        this.responseFactory = new EhcacheEntityResponseFactory();
        this.ehcacheStateService = ehcacheStateService;
        if (ehcacheStateService == null) {
            throw new AssertionError((Object)"Server failed to retrieve EhcacheStateService.");
        }
        this.entityMessenger = (IEntityMessenger)services.getService((ServiceConfiguration)new BasicServiceConfiguration(IEntityMessenger.class));
        if (this.entityMessenger == null) {
            throw new AssertionError((Object)"Server failed to retrieve IEntityMessenger service.");
        }
        try {
            ehcacheStateService.configure();
            this.management = management;
        }
        catch (ConfigurationException e) {
            ehcacheStateService.destroy();
            throw e;
        }
    }

    Set<ClientDescriptor> getConnectedClients() {
        HashSet<ClientDescriptor> clients = new HashSet<ClientDescriptor>();
        for (Map.Entry<ClientDescriptor, ClientState> entry : this.clientStateMap.entrySet()) {
            clients.add(entry.getKey());
        }
        return Collections.unmodifiableSet(clients);
    }

    public void connected(ClientDescriptor clientDescriptor) {
        if (!this.clientStateMap.containsKey(clientDescriptor)) {
            LOGGER.info("Connecting {}", (Object)clientDescriptor);
            ClientState clientState = new ClientState();
            this.clientStateMap.put(clientDescriptor, clientState);
            this.management.clientConnected(clientDescriptor, clientState);
        } else {
            LOGGER.error("Client {} already registered as connected", (Object)clientDescriptor);
        }
    }

    public void disconnected(ClientDescriptor clientDescriptor) {
        ClientState clientState = this.clientStateMap.remove(clientDescriptor);
        if (clientState == null) {
            LOGGER.error("Client {} not registered as connected", (Object)clientDescriptor);
        } else {
            LOGGER.info("Disconnecting {}", (Object)clientDescriptor);
            this.management.clientDisconnected(clientDescriptor, clientState);
        }
    }

    public EhcacheEntityResponse invoke(ClientDescriptor clientDescriptor, EhcacheEntityMessage message) {
        try {
            EhcacheOperationMessage operationMessage;
            EhcacheMessageType messageType;
            if (message instanceof EhcacheOperationMessage && EhcacheMessageType.isLifecycleMessage((EhcacheMessageType)(messageType = (operationMessage = (EhcacheOperationMessage)message).getMessageType()))) {
                return this.invokeLifeCycleOperation(clientDescriptor, (LifecycleMessage)message);
            }
            throw new AssertionError((Object)("Unsupported message : " + message.getClass()));
        }
        catch (ClusterException e) {
            return this.responseFactory.failure(e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
            return this.responseFactory.failure((ClusterException)new InvalidOperationException((Throwable)e));
        }
    }

    public void handleReconnect(ClientDescriptor clientDescriptor, byte[] extendedReconnectData) {
        ClientState clientState = this.clientStateMap.get(clientDescriptor);
        if (clientState == null) {
            throw new AssertionError((Object)("Client " + clientDescriptor + " trying to reconnect is not connected to entity"));
        }
        ClusterTierManagerReconnectMessage reconnectMessage = this.reconnectMessageCodec.decodeReconnectMessage(extendedReconnectData);
        clientState.attach(reconnectMessage.getClientId());
        LOGGER.info("Client '{}' successfully reconnected to newly promoted ACTIVE after failover.", (Object)clientDescriptor);
        this.management.clientReconnected(clientDescriptor, clientState);
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<EhcacheEntityMessage> syncChannel, int concurrencyKey) {
    }

    public void createNew() {
        this.management.init();
        this.management.sharedPoolsConfigured();
    }

    public void loadExisting() {
        this.ehcacheStateService.loadExisting(this.configuration);
        LOGGER.debug("Preparing for handling Inflight Invalidations and independent Passive Evictions in loadExisting");
        this.reconnectComplete.set(false);
        this.management.init();
        this.management.sharedPoolsConfigured();
    }

    private void validateClientConnected(ClientDescriptor clientDescriptor) throws ClusterException {
        ClientState clientState = this.clientStateMap.get(clientDescriptor);
        if (clientState == null) {
            throw new LifecycleException("Client " + clientDescriptor + " is not connected to the cluster tier manager");
        }
    }

    private EhcacheEntityResponse invokeLifeCycleOperation(ClientDescriptor clientDescriptor, LifecycleMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case VALIDATE: {
                this.validate(clientDescriptor, (LifecycleMessage.ValidateStoreManager)message);
                break;
            }
            case PREPARE_FOR_DESTROY: {
                return this.prepareForDestroy();
            }
            default: {
                throw new AssertionError((Object)("Unsupported LifeCycle operation " + message));
            }
        }
        return this.responseFactory.success();
    }

    private EhcacheEntityResponse prepareForDestroy() {
        EhcacheEntityResponse.PrepareForDestroy response = new EhcacheEntityResponse.PrepareForDestroy(this.ehcacheStateService.getStores());
        this.ehcacheStateService.prepareForDestroy();
        return response;
    }

    public void destroy() {
        this.ehcacheStateService.destroy();
    }

    private void validate(ClientDescriptor clientDescriptor, LifecycleMessage.ValidateStoreManager message) throws ClusterException {
        this.validateClientConnected(clientDescriptor);
        ClientState clientState = this.clientStateMap.get(clientDescriptor);
        UUID clientId = clientState.getClientIdentifier();
        if (clientId != null) {
            throw new LifecycleException("Client : " + clientDescriptor + " is already being tracked with Client Id : " + clientId);
        }
        if (this.getTrackedClients().contains(message.getClientId())) {
            throw new InvalidClientIdException("Client ID : " + message.getClientId() + " is already being tracked.");
        }
        this.ehcacheStateService.validate(message.getConfiguration());
        clientState.attach(message.getClientId());
        this.management.clientValidated(clientDescriptor, clientState);
    }

    private Set<UUID> getTrackedClients() {
        return this.clientStateMap.entrySet().stream().filter(entry -> ((ClientState)entry.getValue()).isAttached()).map(entry -> ((ClientState)entry.getValue()).getClientIdentifier()).collect(Collectors.toSet());
    }
}

