/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.EhcacheCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.runnel.decoding.Enm;

public class EhcacheServerCodec
implements MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheServerCodec.class);
    private final EhcacheCodec clientCodec;
    private final PassiveReplicationMessageCodec replicationCodec;

    public EhcacheServerCodec(EhcacheCodec clientCodec, PassiveReplicationMessageCodec replicationCodec) {
        this.clientCodec = clientCodec;
        this.replicationCodec = replicationCodec;
    }

    public byte[] encodeMessage(EhcacheEntityMessage message) throws MessageCodecException {
        if (message instanceof PassiveReplicationMessage) {
            return this.replicationCodec.encode((PassiveReplicationMessage)message);
        }
        return this.clientCodec.encodeMessage(message);
    }

    public EhcacheEntityMessage decodeMessage(byte[] payload) throws MessageCodecException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Enm opCodeEnm = EhcacheCodec.OP_CODE_DECODER.decoder(byteBuffer).enm("opCode");
        if (!opCodeEnm.isFound()) {
            throw new AssertionError((Object)"Got a message without an opCode");
        }
        if (!opCodeEnm.isValid()) {
            LOGGER.warn("Received message with unknown operation code - more recent version at the other end?");
            return null;
        }
        byteBuffer.rewind();
        EhcacheMessageType messageType = (EhcacheMessageType)opCodeEnm.get();
        if (EhcacheMessageType.isPassiveReplicationMessage((EhcacheMessageType)messageType)) {
            return this.replicationCodec.decode(messageType, byteBuffer);
        }
        return this.clientCodec.decodeMessage(byteBuffer, messageType);
    }

    public byte[] encodeResponse(EhcacheEntityResponse response) throws MessageCodecException {
        return this.clientCodec.encodeResponse(response);
    }

    public EhcacheEntityResponse decodeResponse(byte[] payload) throws MessageCodecException {
        return this.clientCodec.decodeResponse(payload);
    }
}

