/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Util;
import org.ehcache.clustered.server.internal.messages.EhcacheDataSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.SyncMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class EhcacheSyncMessageCodec
implements SyncMessageCodec<EhcacheEntityMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheSyncMessageCodec.class);
    private static final String CHAIN_FIELD = "chain";
    private static final String CHAIN_MAP_ENTRIES_SUB_STRUCT = "entries";
    private static final String STATE_REPO_ENTRIES_SUB_STRUCT = "mappings";
    private static final String STATE_REPO_VALUE_FIELD = "value";
    private static final String STATE_REPO_MAP_NAME_FIELD = "mapName";
    private static final Struct CHAIN_MAP_ENTRY_STRUCT = StructBuilder.newStructBuilder().int64("key", 10).struct("chain", 20, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct DATA_SYNC_STRUCT = StructBuilder.newStructBuilder().enm("msgType", 10, SyncMessageType.SYNC_MESSAGE_TYPE_MAPPING).structs("entries", 20, CHAIN_MAP_ENTRY_STRUCT).build();
    private static final Struct STATE_REPO_ENTRY_STRUCT = StructBuilder.newStructBuilder().byteBuffer("key", 10).byteBuffer("value", 20).build();
    private static final Struct STATE_REPO_SYNC_STRUCT = StructBuilder.newStructBuilder().enm("msgType", 10, SyncMessageType.SYNC_MESSAGE_TYPE_MAPPING).string("serverStoreName", 20).string("mapName", 30).structs("mappings", 40, STATE_REPO_ENTRY_STRUCT).build();

    public byte[] encode(int concurrencyKey, EhcacheEntityMessage message) throws MessageCodecException {
        if (message instanceof EhcacheSyncMessage) {
            EhcacheSyncMessage syncMessage = (EhcacheSyncMessage)message;
            switch (syncMessage.getMessageType()) {
                case DATA: {
                    StructEncoder encoder = DATA_SYNC_STRUCT.encoder();
                    EhcacheDataSyncMessage dataSyncMessage = (EhcacheDataSyncMessage)syncMessage;
                    encoder.enm("msgType", (Object)SyncMessageType.DATA);
                    encoder.structs(CHAIN_MAP_ENTRIES_SUB_STRUCT, dataSyncMessage.getChainMap().entrySet(), (entryEncoder, entry) -> {
                        entryEncoder.int64("key", ((Long)entry.getKey()).longValue());
                        entryEncoder.struct(CHAIN_FIELD, entry.getValue(), ChainCodec.CHAIN_ENCODER_FUNCTION);
                    });
                    return encoder.encode().array();
                }
                case STATE_REPO: {
                    StructEncoder encoder = STATE_REPO_SYNC_STRUCT.encoder();
                    EhcacheStateRepoSyncMessage stateRepoSyncMessage = (EhcacheStateRepoSyncMessage)syncMessage;
                    encoder.enm("msgType", (Object)SyncMessageType.STATE_REPO).string("serverStoreName", stateRepoSyncMessage.getCacheId()).string(STATE_REPO_MAP_NAME_FIELD, stateRepoSyncMessage.getMapId());
                    encoder.structs(STATE_REPO_ENTRIES_SUB_STRUCT, stateRepoSyncMessage.getMappings().entrySet(), (entryEncoder, entry) -> entryEncoder.byteBuffer("key", ByteBuffer.wrap(Util.marshall(entry.getKey()))).byteBuffer(STATE_REPO_VALUE_FIELD, ByteBuffer.wrap(Util.marshall(entry.getValue()))));
                    return encoder.encode().array();
                }
            }
            throw new IllegalArgumentException("Sync message codec can not encode " + (Object)((Object)syncMessage.getMessageType()));
        }
        throw new IllegalArgumentException(this.getClass().getName() + " can not encode " + message + " which is not a " + EhcacheSyncMessage.class);
    }

    public EhcacheSyncMessage decode(int concurrencyKey, byte[] payload) throws MessageCodecException {
        ByteBuffer message = ByteBuffer.wrap(payload);
        StructDecoder decoder = DATA_SYNC_STRUCT.decoder(message);
        Enm enm = decoder.enm("msgType");
        if (!enm.isFound()) {
            throw new AssertionError((Object)"Invalid message format - misses the message type field");
        }
        if (!enm.isValid()) {
            LOGGER.warn("Unknown sync message received - ignoring {}", (Object)enm.raw());
            return null;
        }
        switch ((SyncMessageType)((Object)enm.get())) {
            case DATA: {
                message.rewind();
                decoder = DATA_SYNC_STRUCT.decoder(message);
                Map<Long, Chain> chainMap = this.decodeChainMapEntries((StructDecoder<Void>)decoder);
                return new EhcacheDataSyncMessage(chainMap);
            }
            case STATE_REPO: {
                message.rewind();
                decoder = STATE_REPO_SYNC_STRUCT.decoder(message);
                String storeId = decoder.string("serverStoreName");
                String mapId = decoder.string(STATE_REPO_MAP_NAME_FIELD);
                ConcurrentHashMap<Object, Object> mappings = new ConcurrentHashMap<Object, Object>();
                StructArrayDecoder structsDecoder = decoder.structs(STATE_REPO_ENTRIES_SUB_STRUCT);
                if (structsDecoder != null) {
                    while (structsDecoder.hasNext()) {
                        StructDecoder structDecoder = structsDecoder.next();
                        Object key = Util.unmarshall((ByteBuffer)structDecoder.byteBuffer("key"));
                        Object value = Util.unmarshall((ByteBuffer)structDecoder.byteBuffer(STATE_REPO_VALUE_FIELD));
                        mappings.put(key, value);
                    }
                }
                return new EhcacheStateRepoSyncMessage(storeId, mapId, mappings);
            }
        }
        throw new AssertionError((Object)"Cannot happen given earlier checks");
    }

    private Map<Long, Chain> decodeChainMapEntries(StructDecoder<Void> decoder) {
        HashMap<Long, Chain> chainMap = new HashMap<Long, Chain>();
        StructArrayDecoder entriesDecoder = decoder.structs(CHAIN_MAP_ENTRIES_SUB_STRUCT);
        if (entriesDecoder != null) {
            for (int i = 0; i < entriesDecoder.length(); ++i) {
                StructDecoder entryDecoder = entriesDecoder.next();
                Long key = entryDecoder.int64("key");
                StructDecoder chainDecoder = entryDecoder.struct(CHAIN_FIELD);
                Chain chain = ChainCodec.decode((StructDecoder)chainDecoder);
                chainMap.put(key, chain);
                entryDecoder.end();
            }
        }
        return chainMap;
    }
}

