/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class PassiveReplicationMessage
extends EhcacheOperationMessage {
    public void setId(long id) {
        throw new UnsupportedOperationException("This method is not supported on replication message");
    }

    public static class InvalidationCompleteMessage
    extends PassiveReplicationMessage
    implements ConcurrentEntityMessage {
        private final long key;

        public InvalidationCompleteMessage(long key) {
            this.key = key;
        }

        public long concurrencyKey() {
            return this.key;
        }

        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.INVALIDATION_COMPLETE;
        }

        public long getKey() {
            return this.key;
        }

        public long getId() {
            throw new UnsupportedOperationException("Not supported for InvalidationCompleteMessage");
        }

        public UUID getClientId() {
            throw new UnsupportedOperationException("Not supported for InvalidationCompleteMessage");
        }
    }

    public static class ClearInvalidationCompleteMessage
    extends PassiveReplicationMessage {
        public long getId() {
            throw new UnsupportedOperationException("Not supported for ClearInvalidationCompleteMessage");
        }

        public UUID getClientId() {
            throw new UnsupportedOperationException("Not supported for ClearInvalidationCompleteMessage");
        }

        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR_INVALIDATION_COMPLETE;
        }
    }

    public static class ChainReplicationMessage
    extends ClientIDTrackerMessage
    implements ConcurrentEntityMessage {
        private final long key;
        private final Chain chain;
        private final long msgId;

        public ChainReplicationMessage(long key, Chain chain, long msgId, UUID clientId) {
            super(clientId);
            this.msgId = msgId;
            this.key = key;
            this.chain = chain;
        }

        public long getKey() {
            return this.key;
        }

        public Chain getChain() {
            return this.chain;
        }

        @Override
        public long getId() {
            return this.msgId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CHAIN_REPLICATION_OP;
        }

        public long concurrencyKey() {
            return this.key;
        }
    }

    public static class ClientIDTrackerMessage
    extends PassiveReplicationMessage {
        private final UUID clientId;

        public ClientIDTrackerMessage(UUID clientId) {
            this.clientId = clientId;
        }

        public UUID getClientId() {
            return this.clientId;
        }

        public long getId() {
            throw new UnsupportedOperationException("Not supported for ClientIDTrackerMessage");
        }

        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_ID_TRACK_OP;
        }
    }
}

