/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class PassiveReplicationMessageCodec {
    private static final String CHAIN_FIELD = "chain";
    private static final Struct CLIENT_ID_TRACK_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msbUUID", 20).int64("lsbUUID", 21).build();
    private static final Struct CHAIN_REPLICATION_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).int64("key", 40).struct("chain", 45, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLEAR_INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private static final Struct INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 20).build();
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    public byte[] encode(PassiveReplicationMessage message) {
        switch (message.getMessageType()) {
            case CLIENT_ID_TRACK_OP: {
                return this.encodeClientIdTrackMessage((PassiveReplicationMessage.ClientIDTrackerMessage)message);
            }
            case CHAIN_REPLICATION_OP: {
                return this.encodeChainReplicationMessage((PassiveReplicationMessage.ChainReplicationMessage)message);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.encodeClearInvalidationCompleteMessage((PassiveReplicationMessage.ClearInvalidationCompleteMessage)message);
            }
            case INVALIDATION_COMPLETE: {
                return this.encodeInvalidationCompleteMessage((PassiveReplicationMessage.InvalidationCompleteMessage)message);
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + message.getMessageType());
    }

    private byte[] encodeInvalidationCompleteMessage(PassiveReplicationMessage.InvalidationCompleteMessage message) {
        StructEncoder encoder = INVALIDATION_COMPLETE_STRUCT.encoder();
        encoder.enm("opCode", (Object)message.getMessageType()).int64("key", message.getKey());
        return encoder.encode().array();
    }

    private byte[] encodeClearInvalidationCompleteMessage(PassiveReplicationMessage.ClearInvalidationCompleteMessage message) {
        StructEncoder encoder = CLEAR_INVALIDATION_COMPLETE_STRUCT.encoder();
        encoder.enm("opCode", (Object)message.getMessageType());
        return encoder.encode().array();
    }

    private byte[] encodeChainReplicationMessage(PassiveReplicationMessage.ChainReplicationMessage message) {
        StructEncoder encoder = CHAIN_REPLICATION_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, (EhcacheOperationMessage)message);
        encoder.int64("key", message.getKey());
        encoder.struct(CHAIN_FIELD, (Object)message.getChain(), ChainCodec.CHAIN_ENCODER_FUNCTION);
        return encoder.encode().array();
    }

    private byte[] encodeClientIdTrackMessage(PassiveReplicationMessage.ClientIDTrackerMessage message) {
        StructEncoder encoder = CLIENT_ID_TRACK_STRUCT.encoder();
        encoder.enm("opCode", (Object)message.getMessageType()).int64("msbUUID", message.getClientId().getMostSignificantBits()).int64("lsbUUID", message.getClientId().getLeastSignificantBits());
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case CLIENT_ID_TRACK_OP: {
                return this.decodeClientIdTrackMessage(messageBuffer);
            }
            case CHAIN_REPLICATION_OP: {
                return this.decodeChainReplicationMessage(messageBuffer);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.decodeClearInvalidationCompleteMessage(messageBuffer);
            }
            case INVALIDATION_COMPLETE: {
                return this.decodeInvalidationCompleteMessage(messageBuffer);
            }
        }
        throw new UnsupportedOperationException("Unknown message type: " + messageType);
    }

    private PassiveReplicationMessage.InvalidationCompleteMessage decodeInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = INVALIDATION_COMPLETE_STRUCT.decoder(messageBuffer);
        Long key = decoder.int64("key");
        return new PassiveReplicationMessage.InvalidationCompleteMessage(key);
    }

    private PassiveReplicationMessage.ClearInvalidationCompleteMessage decodeClearInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        return new PassiveReplicationMessage.ClearInvalidationCompleteMessage();
    }

    private PassiveReplicationMessage.ChainReplicationMessage decodeChainReplicationMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CHAIN_REPLICATION_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        Long key = decoder.int64("key");
        Chain chain = ChainCodec.decode((StructDecoder)decoder.struct(CHAIN_FIELD));
        return new PassiveReplicationMessage.ChainReplicationMessage(key, chain, msgId, clientId);
    }

    private PassiveReplicationMessage.ClientIDTrackerMessage decodeClientIdTrackMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CLIENT_ID_TRACK_STRUCT.decoder(messageBuffer);
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        return new PassiveReplicationMessage.ClientIDTrackerMessage(clientId);
    }
}

