/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.util.concurrent.CompletableFuture;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.management.ClusterTierClientState;
import org.ehcache.clustered.server.management.ClusterTierClientStateBinding;
import org.ehcache.clustered.server.management.ClusterTierStateSettingsManagementProvider;
import org.ehcache.clustered.server.management.Notification;
import org.ehcache.clustered.server.management.PoolBinding;
import org.ehcache.clustered.server.management.PoolSettingsManagementProvider;
import org.ehcache.clustered.server.management.PoolStatisticsManagementProvider;
import org.ehcache.clustered.server.management.ServerStoreBinding;
import org.ehcache.clustered.server.management.ServerStoreSettingsManagementProvider;
import org.ehcache.clustered.server.management.ServerStoreStatisticsManagementProvider;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.ActiveEntityMonitoringServiceConfiguration;
import org.terracotta.management.service.monitoring.ConsumerManagementRegistry;
import org.terracotta.management.service.monitoring.ConsumerManagementRegistryConfiguration;
import org.terracotta.management.service.monitoring.EntityMonitoringService;
import org.terracotta.management.service.monitoring.PassiveEntityMonitoringServiceConfiguration;
import org.terracotta.monitoring.IMonitoringProducer;

public class ClusterTierManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagement.class);
    private final ConsumerManagementRegistry managementRegistry;
    private final EhcacheStateService ehcacheStateService;
    private final String storeIdentifier;

    public ClusterTierManagement(ServiceRegistry services, EhcacheStateService ehcacheStateService, boolean active, String storeIdentifier, String clusterTierManagerIdentifier) {
        IMonitoringProducer monitoringProducer;
        this.ehcacheStateService = ehcacheStateService;
        this.storeIdentifier = storeIdentifier;
        EntityMonitoringService entityMonitoringService = active ? (EntityMonitoringService)services.getService((ServiceConfiguration)new ActiveEntityMonitoringServiceConfiguration()) : ((monitoringProducer = (IMonitoringProducer)services.getService((ServiceConfiguration)new BasicServiceConfiguration(IMonitoringProducer.class))) == null ? null : (EntityMonitoringService)services.getService((ServiceConfiguration)new PassiveEntityMonitoringServiceConfiguration(monitoringProducer)));
        ConsumerManagementRegistry consumerManagementRegistry = this.managementRegistry = entityMonitoringService == null ? null : (ConsumerManagementRegistry)services.getService((ServiceConfiguration)new ConsumerManagementRegistryConfiguration(entityMonitoringService));
        if (this.managementRegistry != null) {
            if (active) {
                this.managementRegistry.addManagementProvider((ManagementProvider)new ClusterTierStateSettingsManagementProvider());
            }
            this.managementRegistry.addManagementProvider((ManagementProvider)new ServerStoreSettingsManagementProvider(clusterTierManagerIdentifier));
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolSettingsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new ServerStoreStatisticsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolStatisticsManagementProvider(ehcacheStateService));
        }
    }

    public void init() {
        if (this.managementRegistry != null) {
            LOGGER.trace("init({})", (Object)this.storeIdentifier);
            ServerSideServerStore serverStore = this.ehcacheStateService.getStore(this.storeIdentifier);
            ServerStoreBinding serverStoreBinding = new ServerStoreBinding(this.storeIdentifier, serverStore);
            CompletableFuture<Void> r1 = this.managementRegistry.register((Object)serverStoreBinding);
            ServerSideConfiguration.Pool pool = this.ehcacheStateService.getDedicatedResourcePool(this.storeIdentifier);
            CompletableFuture<Void> allOf = pool != null ? CompletableFuture.allOf(r1, this.managementRegistry.register((Object)new PoolBinding(this.storeIdentifier, pool, PoolBinding.AllocationType.DEDICATED))) : r1;
            allOf.thenRun(() -> {
                this.managementRegistry.refresh();
                this.managementRegistry.pushServerEntityNotification((Object)serverStoreBinding, Notification.EHCACHE_SERVER_STORE_CREATED.name());
            });
        }
    }

    public void clientConnected(ClientDescriptor clientDescriptor, ClusterTierClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientConnected({})", (Object)clientDescriptor);
            this.managementRegistry.registerAndRefresh((Object)new ClusterTierClientStateBinding(clientDescriptor, clientState));
        }
    }

    public void clientDisconnected(ClientDescriptor clientDescriptor, ClusterTierClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientDisconnected({})", (Object)clientDescriptor);
            ClusterTierClientStateBinding clientStateBinding = new ClusterTierClientStateBinding(clientDescriptor, clientState);
            this.managementRegistry.pushServerEntityNotification((Object)clientStateBinding, Notification.EHCACHE_SERVER_STORE_RELEASED.name());
            this.managementRegistry.unregisterAndRefresh((Object)clientStateBinding);
        }
    }

    public void clientReconnected(ClientDescriptor clientDescriptor, ClusterTierClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientReconnected({})", (Object)clientDescriptor);
            this.managementRegistry.pushServerEntityNotification((Object)new ClusterTierClientStateBinding(clientDescriptor, clientState), Notification.EHCACHE_SERVER_STORE_CLIENT_RECONNECTED.name());
        }
    }

    public void clientValidated(ClientDescriptor clientDescriptor, ClusterTierClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientValidated({})", (Object)clientDescriptor);
            ClusterTierClientStateBinding clientStateBinding = new ClusterTierClientStateBinding(clientDescriptor, clientState);
            this.managementRegistry.unregister((Object)clientStateBinding);
            this.managementRegistry.registerAndRefresh((Object)clientStateBinding).thenRun(() -> this.managementRegistry.pushServerEntityNotification((Object)clientStateBinding, Notification.EHCACHE_SERVER_STORE_ATTACHED.name()));
        }
    }
}

