/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.util.concurrent.CompletableFuture;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.server.ClientState;
import org.ehcache.clustered.server.management.ClientStateBinding;
import org.ehcache.clustered.server.management.ClientStateSettingsManagementProvider;
import org.ehcache.clustered.server.management.ClusterTierManagerBinding;
import org.ehcache.clustered.server.management.ClusterTierManagerSettingsManagementProvider;
import org.ehcache.clustered.server.management.Notification;
import org.ehcache.clustered.server.management.PoolBinding;
import org.ehcache.clustered.server.management.PoolSettingsManagementProvider;
import org.ehcache.clustered.server.management.PoolStatisticsManagementProvider;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.ActiveEntityMonitoringServiceConfiguration;
import org.terracotta.management.service.monitoring.ConsumerManagementRegistry;
import org.terracotta.management.service.monitoring.ConsumerManagementRegistryConfiguration;
import org.terracotta.management.service.monitoring.EntityMonitoringService;
import org.terracotta.management.service.monitoring.PassiveEntityMonitoringServiceConfiguration;
import org.terracotta.monitoring.IMonitoringProducer;

public class Management {
    private static final Logger LOGGER = LoggerFactory.getLogger(Management.class);
    private final ConsumerManagementRegistry managementRegistry;
    private final EhcacheStateService ehcacheStateService;
    private final String clusterTierManagerIdentifier;

    public Management(ServiceRegistry services, EhcacheStateService ehcacheStateService, boolean active, String clusterTierManagerIdentifier) {
        IMonitoringProducer monitoringProducer;
        this.ehcacheStateService = ehcacheStateService;
        EntityMonitoringService entityMonitoringService = active ? (EntityMonitoringService)services.getService((ServiceConfiguration)new ActiveEntityMonitoringServiceConfiguration()) : ((monitoringProducer = (IMonitoringProducer)services.getService((ServiceConfiguration)new BasicServiceConfiguration(IMonitoringProducer.class))) == null ? null : (EntityMonitoringService)services.getService((ServiceConfiguration)new PassiveEntityMonitoringServiceConfiguration(monitoringProducer)));
        ConsumerManagementRegistry consumerManagementRegistry = this.managementRegistry = entityMonitoringService == null ? null : (ConsumerManagementRegistry)services.getService((ServiceConfiguration)new ConsumerManagementRegistryConfiguration(entityMonitoringService));
        if (this.managementRegistry != null) {
            if (active) {
                this.managementRegistry.addManagementProvider((ManagementProvider)new ClientStateSettingsManagementProvider());
            }
            this.registerClusterTierManagerSettingsProvider();
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolSettingsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolStatisticsManagementProvider(ehcacheStateService));
        }
        this.clusterTierManagerIdentifier = clusterTierManagerIdentifier;
    }

    protected EhcacheStateService getEhcacheStateService() {
        return this.ehcacheStateService;
    }

    public ConsumerManagementRegistry getManagementRegistry() {
        return this.managementRegistry;
    }

    protected ClusterTierManagerBinding generateClusterTierManagerBinding() {
        return new ClusterTierManagerBinding(this.clusterTierManagerIdentifier, this.getEhcacheStateService());
    }

    protected void registerClusterTierManagerSettingsProvider() {
        this.getManagementRegistry().addManagementProvider((ManagementProvider)new ClusterTierManagerSettingsManagementProvider());
    }

    public void init() {
        if (this.managementRegistry != null) {
            LOGGER.trace("init()");
            CompletableFuture.allOf(this.managementRegistry.register((Object)this.generateClusterTierManagerBinding()), this.managementRegistry.register((Object)PoolBinding.ALL_SHARED)).thenRun(() -> ((ConsumerManagementRegistry)this.managementRegistry).refresh());
        }
    }

    public void clientConnected(ClientDescriptor clientDescriptor, ClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientConnected({})", (Object)clientDescriptor);
            this.managementRegistry.registerAndRefresh((Object)new ClientStateBinding(clientDescriptor, clientState));
        }
    }

    public void clientDisconnected(ClientDescriptor clientDescriptor, ClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientDisconnected({})", (Object)clientDescriptor);
            this.managementRegistry.unregisterAndRefresh((Object)new ClientStateBinding(clientDescriptor, clientState));
        }
    }

    public void clientReconnected(ClientDescriptor clientDescriptor, ClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientReconnected({})", (Object)clientDescriptor);
            this.managementRegistry.refresh();
            this.managementRegistry.pushServerEntityNotification((Object)new ClientStateBinding(clientDescriptor, clientState), Notification.EHCACHE_CLIENT_RECONNECTED.name());
        }
    }

    public void sharedPoolsConfigured() {
        if (this.managementRegistry != null) {
            LOGGER.trace("sharedPoolsConfigured()");
            CompletableFuture.allOf((CompletableFuture[])this.ehcacheStateService.getSharedResourcePools().entrySet().stream().map(e -> this.managementRegistry.register((Object)new PoolBinding((String)e.getKey(), (ServerSideConfiguration.Pool)e.getValue(), PoolBinding.AllocationType.SHARED))).toArray(CompletableFuture[]::new)).thenRun(() -> {
                this.managementRegistry.refresh();
                this.managementRegistry.pushServerEntityNotification((Object)PoolBinding.ALL_SHARED, Notification.EHCACHE_RESOURCE_POOLS_CONFIGURED.name());
            });
        }
    }

    public void clientValidated(ClientDescriptor clientDescriptor, ClientState clientState) {
        if (this.managementRegistry != null) {
            LOGGER.trace("clientValidated({})", (Object)clientDescriptor);
            this.managementRegistry.refresh();
            this.managementRegistry.pushServerEntityNotification((Object)new ClientStateBinding(clientDescriptor, clientState), Notification.EHCACHE_CLIENT_VALIDATED.name());
        }
    }
}

