/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import org.terracotta.offheapstore.storage.portability.Portability;

class LongPortability
implements Portability<Long> {
    static final Portability<Long> INSTANCE = new LongPortability();

    private LongPortability() {
    }

    public ByteBuffer encode(Long value) {
        return ByteBuffer.allocate(8).putLong(0, value);
    }

    public Long decode(ByteBuffer buffer) {
        return buffer.getLong(0);
    }

    public boolean equals(Object value, ByteBuffer buffer) {
        if (value instanceof Long) {
            return ((Long)value).longValue() == buffer.getLong(0);
        }
        return false;
    }
}

