/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.Util;
import org.ehcache.clustered.server.offheap.InternalChain;
import org.ehcache.clustered.server.offheap.OffHeapChainStorageEngine;
import org.terracotta.offheapstore.MapInternals;
import org.terracotta.offheapstore.ReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.eviction.EvictionListener;
import org.terracotta.offheapstore.eviction.EvictionListeningReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.portability.Portability;

public class OffHeapChainMap<K>
implements MapInternals {
    private final ReadWriteLockedOffHeapClockCache<K, InternalChain> heads;
    private final OffHeapChainStorageEngine<K> chainStorage;
    private volatile ChainMapEvictionListener<K> evictionListener;
    private static final Chain EMPTY_CHAIN = new Chain(){

        public Iterator<Element> reverseIterator() {
            return Collections.emptyList().iterator();
        }

        public boolean isEmpty() {
            return true;
        }

        public Iterator<Element> iterator() {
            return Collections.emptyList().iterator();
        }
    };

    public OffHeapChainMap(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean shareByThieving) {
        this.chainStorage = new OffHeapChainStorageEngine<K>(source, keyPortability, minPageSize, maxPageSize, shareByThieving, shareByThieving);
        EvictionListener listener = new EvictionListener<K, InternalChain>(){

            public void evicting(Callable<Map.Entry<K, InternalChain>> callable) {
                try {
                    Map.Entry entry = callable.call();
                    try {
                        if (OffHeapChainMap.this.evictionListener != null) {
                            OffHeapChainMap.this.evictionListener.onEviction(entry.getKey());
                        }
                    }
                    finally {
                        entry.getValue().close();
                    }
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
        this.heads = new EvictionListeningReadWriteLockedOffHeapClockCache(listener, source, this.chainStorage);
    }

    OffHeapChainMap(ReadWriteLockedOffHeapClockCache<K, InternalChain> heads, OffHeapChainStorageEngine<K> chainStorage) {
        this.chainStorage = chainStorage;
        this.heads = heads;
    }

    void setEvictionListener(ChainMapEvictionListener<K> listener) {
        this.evictionListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain get(K key) {
        Lock lock = this.heads.readLock();
        lock.lock();
        try {
            InternalChain chain = (InternalChain)this.heads.get(key);
            if (chain == null) {
                Chain chain2 = EMPTY_CHAIN;
                return chain2;
            }
            try {
                Chain chain3 = chain.detach();
                chain.close();
                return chain3;
            }
            catch (Throwable throwable) {
                chain.close();
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Chain getAndAppend(K key, ByteBuffer element) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                this.heads.put(key, (Object)this.chainStorage.newChain(element));
                var5_5 = OffHeapChainMap.EMPTY_CHAIN;
                return var5_5;
            }
            try {
                current = chain.detach();
                if (chain.append(element)) {
                    var6_6 = current;
                    return var6_6;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void append(K key, ByteBuffer element) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                this.heads.put(key, (Object)this.chainStorage.newChain(element));
                return;
            }
            try {
                if (chain.append(element)) {
                    return;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void replaceAtHead(K key, Chain expected, Chain replacement) {
        lock = this.heads.writeLock();
        lock.lock();
        while (true) lbl-1000:
        // 3 sources

        {
            if ((chain = (InternalChain)this.heads.get(key)) == null) {
                if (expected.isEmpty()) {
                    throw new IllegalArgumentException("Empty expected sequence");
                }
                return;
            }
            try {
                if (chain.replace(expected, replacement)) {
                    return;
                }
                this.evict();
            }
            finally {
                chain.close();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, Chain chain) {
        block8: {
            Lock lock = this.heads.writeLock();
            lock.lock();
            try {
                InternalChain current = (InternalChain)this.heads.get(key);
                if (current != null) {
                    try {
                        this.replaceAtHead(key, current.detach(), chain);
                        break block8;
                    }
                    finally {
                        current.close();
                    }
                }
                for (Element x : chain) {
                    this.append(key, x.getPayload());
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void clear() {
        this.heads.writeLock().lock();
        try {
            this.heads.clear();
        }
        finally {
            this.heads.writeLock().unlock();
        }
    }

    public Set<K> keySet() {
        this.heads.writeLock().lock();
        try {
            Set set = this.heads.keySet();
            return set;
        }
        finally {
            this.heads.writeLock().unlock();
        }
    }

    private void evict() {
        int evictionIndex = this.heads.getEvictionIndex();
        if (evictionIndex < 0) {
            StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed - Everything Pinned (");
            sb.append(this.getSize()).append(" mappings) \n").append("Storage Engine : ").append(this.chainStorage);
            throw new OversizeMappingException(sb.toString());
        }
        this.heads.evict(evictionIndex, false);
    }

    public static Chain chain(ByteBuffer ... buffers) {
        final ArrayList<Element> list = new ArrayList<Element>();
        for (ByteBuffer b : buffers) {
            list.add(OffHeapChainMap.element(b));
        }
        return new Chain(){
            final List<Element> elements;
            {
                this.elements = Collections.unmodifiableList(list);
            }

            public Iterator<Element> iterator() {
                return this.elements.iterator();
            }

            public Iterator<Element> reverseIterator() {
                return Util.reverseIterator(this.elements);
            }

            public boolean isEmpty() {
                return this.elements.isEmpty();
            }
        };
    }

    private static Element element(final ByteBuffer b) {
        return new Element(){

            public ByteBuffer getPayload() {
                return b.asReadOnlyBuffer();
            }
        };
    }

    public long getSize() {
        return this.heads.getSize();
    }

    public long getTableCapacity() {
        return this.heads.getTableCapacity();
    }

    public long getUsedSlotCount() {
        return this.heads.getUsedSlotCount();
    }

    public long getRemovedSlotCount() {
        return this.heads.getRemovedSlotCount();
    }

    public int getReprobeLength() {
        return this.heads.getReprobeLength();
    }

    public long getAllocatedMemory() {
        return this.heads.getAllocatedMemory();
    }

    public long getOccupiedMemory() {
        return this.heads.getOccupiedMemory();
    }

    public long getVitalMemory() {
        return this.heads.getVitalMemory();
    }

    public long getDataAllocatedMemory() {
        return this.heads.getDataAllocatedMemory();
    }

    public long getDataOccupiedMemory() {
        return this.heads.getDataOccupiedMemory();
    }

    public long getDataVitalMemory() {
        return this.heads.getDataVitalMemory();
    }

    public long getDataSize() {
        return this.heads.getDataSize();
    }

    boolean shrink() {
        return this.heads.shrink();
    }

    Lock writeLock() {
        return this.heads.writeLock();
    }

    protected void storageEngineFailure(Object failure) {
    }

    static interface ChainMapEvictionListener<K> {
        public void onEviction(K var1);
    }
}

