/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.store.Util;
import org.ehcache.clustered.server.offheap.InternalChain;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;

class OffHeapChainStorageEngine<K>
implements StorageEngine<K, InternalChain> {
    private static final int ELEMENT_HEADER_SEQUENCE_OFFSET = 0;
    private static final int ELEMENT_HEADER_LENGTH_OFFSET = 8;
    private static final int ELEMENT_HEADER_NEXT_OFFSET = 12;
    private static final int ELEMENT_HEADER_SIZE = 20;
    private static final int CHAIN_HEADER_KEY_LENGTH_OFFSET = 0;
    private static final int CHAIN_HEADER_KEY_HASH_OFFSET = 4;
    private static final int CHAIN_HEADER_TAIL_OFFSET = 8;
    private static final int CHAIN_HEADER_SIZE = 16;
    private final OffHeapStorageArea storage;
    private final Portability<? super K> keyPortability;
    private final Set<AttachedInternalChain> activeChains = Collections.newSetFromMap(new ConcurrentHashMap());
    private StorageEngine.Owner owner;
    private long nextSequenceNumber = 0L;

    public OffHeapChainStorageEngine(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean thief, boolean victim) {
        this.storage = new OffHeapStorageArea(PointerSize.LONG, (OffHeapStorageArea.Owner)new StorageOwner(), source, minPageSize, maxPageSize, thief, victim);
        this.keyPortability = keyPortability;
    }

    Set<AttachedInternalChain> getActiveChains() {
        return this.activeChains;
    }

    InternalChain newChain(ByteBuffer element) {
        return new PrimordialChain(element);
    }

    public Long writeMapping(K key, InternalChain value, int hash, int metadata) {
        if (value instanceof PrimordialChain) {
            return this.createAttachedChain(key, hash, (PrimordialChain)value);
        }
        throw new AssertionError((Object)"only detached internal chains should be initially written");
    }

    public void attachedMapping(long encoding, int hash, int metadata) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeMapping(long encoding, int hash, boolean removal) {
        try (AttachedInternalChain chain = new AttachedInternalChain(encoding);){
            chain.free();
        }
    }

    public InternalChain readValue(long encoding) {
        return new AttachedInternalChain(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalsValue(Object value, long encoding) {
        try (AttachedInternalChain chain = new AttachedInternalChain(encoding);){
            boolean bl = chain.equals(value);
            return bl;
        }
    }

    public K readKey(long encoding, int hashCode) {
        return (K)this.keyPortability.decode(this.readKeyBuffer(encoding));
    }

    public boolean equalsKey(Object key, long encoding) {
        return this.keyPortability.equals(key, this.readKeyBuffer(encoding));
    }

    private ByteBuffer readKeyBuffer(long encoding) {
        int keyLength = this.readKeySize(encoding);
        int elemLength = this.storage.readInt(encoding + 16L + 8L);
        return this.storage.readBuffer(encoding + 16L + 20L + (long)elemLength, keyLength);
    }

    private int readKeyHash(long encoding) {
        return this.storage.readInt(encoding + 4L);
    }

    private int readKeySize(long encoding) {
        return Integer.MAX_VALUE & this.storage.readInt(encoding + 0L);
    }

    public void clear() {
        this.storage.clear();
    }

    public long getAllocatedMemory() {
        return this.storage.getAllocatedMemory();
    }

    public long getOccupiedMemory() {
        return this.storage.getOccupiedMemory();
    }

    public long getVitalMemory() {
        return this.getOccupiedMemory();
    }

    public long getDataSize() {
        return this.storage.getAllocatedMemory();
    }

    public void invalidateCache() {
    }

    public void bind(StorageEngine.Owner owner) {
        this.owner = owner;
    }

    public void destroy() {
        this.storage.destroy();
    }

    public boolean shrink() {
        return this.storage.shrink();
    }

    private long writeElement(long address, ByteBuffer element) {
        this.storage.writeLong(address + 0L, this.nextSequenceNumber++);
        this.storage.writeInt(address + 8L, element.remaining());
        this.storage.writeBuffer(address + 20L, element.duplicate());
        return address;
    }

    private Long createAttachedChain(K key, int hash, PrimordialChain value) {
        ByteBuffer keyBuffer = this.keyPortability.encode(key);
        ByteBuffer elemBuffer = value.element;
        return this.createAttachedChain(keyBuffer, hash, elemBuffer);
    }

    private Long createAttachedChain(ByteBuffer keyBuffer, int hash, ByteBuffer elemBuffer) {
        long chain = this.storage.allocate((long)(keyBuffer.remaining() + elemBuffer.remaining() + 16 + 20));
        if (chain < 0L) {
            return null;
        }
        int keySize = keyBuffer.remaining();
        this.storage.writeInt(chain + 4L, hash);
        this.storage.writeInt(chain + 0L, Integer.MIN_VALUE | keySize);
        this.storage.writeBuffer(chain + 16L + 20L + (long)elemBuffer.remaining(), keyBuffer);
        long element = chain + 16L;
        this.writeElement(element, elemBuffer);
        this.storage.writeLong(element + 12L, chain);
        this.storage.writeLong(chain + 8L, element);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long createAttachedChain(ByteBuffer readKeyBuffer, int hash, Chain from) {
        Iterator iterator = from.iterator();
        Long address = this.createAttachedChain(readKeyBuffer, hash, ((Element)iterator.next()).getPayload());
        if (address == null) {
            return null;
        }
        try (AttachedInternalChain chain = new AttachedInternalChain(address);){
            while (iterator.hasNext()) {
                if (chain.append(((Element)iterator.next()).getPayload())) continue;
                chain.free();
                Long l = null;
                return l;
            }
        }
        return address;
    }

    private long findHead(long address) {
        while (!this.isHead(address)) {
            address = this.storage.readLong(address + 12L);
        }
        return address;
    }

    private boolean isHead(long address) {
        return this.storage.readInt(address + 0L) < 0;
    }

    class StorageOwner
    implements OffHeapStorageArea.Owner {
        StorageOwner() {
        }

        public boolean evictAtAddress(long address, boolean shrink) {
            long chain = OffHeapChainStorageEngine.this.findHead(address);
            for (AttachedInternalChain activeChain : OffHeapChainStorageEngine.this.activeChains) {
                if (activeChain.chain != chain) continue;
                return false;
            }
            int hash = OffHeapChainStorageEngine.this.storage.readInt(chain + 4L);
            int slot = OffHeapChainStorageEngine.this.owner.getSlotForHashAndEncoding(hash, chain, -1L);
            return OffHeapChainStorageEngine.this.owner.evict(slot, shrink);
        }

        public Lock writeLock() {
            return OffHeapChainStorageEngine.this.owner.writeLock();
        }

        public boolean isThief() {
            return OffHeapChainStorageEngine.this.owner.isThiefForTableAllocations();
        }

        public boolean moved(long from, long to) {
            if (OffHeapChainStorageEngine.this.isHead(to)) {
                int hashCode = OffHeapChainStorageEngine.this.storage.readInt(to + 4L);
                if (!OffHeapChainStorageEngine.this.owner.updateEncoding(hashCode, from, to, -1L)) {
                    return false;
                }
                long tail = OffHeapChainStorageEngine.this.storage.readLong(to + 8L);
                if (tail == from + 16L) {
                    tail = to + 16L;
                    OffHeapChainStorageEngine.this.storage.writeLong(to + 8L, tail);
                }
                OffHeapChainStorageEngine.this.storage.writeLong(tail + 12L, to);
                for (AttachedInternalChain activeChain : OffHeapChainStorageEngine.this.activeChains) {
                    activeChain.moved(from, to);
                }
                return true;
            }
            long chain = OffHeapChainStorageEngine.this.findHead(to);
            long tail = OffHeapChainStorageEngine.this.storage.readLong(chain + 8L);
            if (tail == from) {
                OffHeapChainStorageEngine.this.storage.writeLong(chain + 8L, to);
            }
            long element = chain + 16L;
            while (element != chain) {
                long next = OffHeapChainStorageEngine.this.storage.readLong(element + 12L);
                if (next == from) {
                    OffHeapChainStorageEngine.this.storage.writeLong(element + 12L, to);
                    return true;
                }
                element = next;
            }
            throw new AssertionError();
        }

        public int sizeOf(long address) {
            if (OffHeapChainStorageEngine.this.isHead(address)) {
                int keySize = OffHeapChainStorageEngine.this.readKeySize(address);
                return 16 + keySize + this.sizeOf(address + 16L);
            }
            int elementSize = OffHeapChainStorageEngine.this.storage.readInt(address + 8L);
            return 20 + elementSize;
        }
    }

    private final class AttachedInternalChain
    implements InternalChain {
        private long chain;

        AttachedInternalChain(long address) {
            this.chain = address;
            OffHeapChainStorageEngine.this.activeChains.add(this);
        }

        @Override
        public Chain detach() {
            ArrayList<Element> buffers = new ArrayList<Element>();
            long element = this.chain + 16L;
            do {
                buffers.add(this.element(this.readElementBuffer(element), this.readElementSequenceNumber(element)));
            } while ((element = OffHeapChainStorageEngine.this.storage.readLong(element + 12L)) != this.chain);
            return new DetachedChain(buffers);
        }

        @Override
        public boolean append(ByteBuffer element) {
            long newTail = this.createElement(element);
            if (newTail < 0L) {
                return false;
            }
            long oldTail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
            OffHeapChainStorageEngine.this.storage.writeLong(newTail + 12L, this.chain);
            OffHeapChainStorageEngine.this.storage.writeLong(oldTail + 12L, newTail);
            OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, newTail);
            return true;
        }

        @Override
        public boolean replace(Chain expected, Chain replacement) {
            if (expected.isEmpty()) {
                throw new IllegalArgumentException("Empty expected sequence");
            }
            if (replacement.isEmpty()) {
                return this.removeHeader(expected);
            }
            return this.replaceHeader(expected, replacement);
        }

        public boolean removeHeader(Chain header) {
            long prefixTail;
            long suffixHead = this.chain + 16L;
            Iterator iterator = header.iterator();
            do {
                if (!this.compare((Element)iterator.next(), suffixHead)) {
                    return true;
                }
                prefixTail = suffixHead;
                suffixHead = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
            } while (iterator.hasNext());
            if (suffixHead == this.chain) {
                int slot = OffHeapChainStorageEngine.this.owner.getSlotForHashAndEncoding(OffHeapChainStorageEngine.this.readKeyHash(this.chain), this.chain, -1L);
                if (!OffHeapChainStorageEngine.this.owner.evict(slot, true)) {
                    throw new AssertionError((Object)("Unexpected failure to evict slot " + slot));
                }
                return true;
            }
            int hash = OffHeapChainStorageEngine.this.readKeyHash(this.chain);
            int elemSize = OffHeapChainStorageEngine.this.storage.readInt(suffixHead + 8L);
            ByteBuffer elemBuffer = OffHeapChainStorageEngine.this.storage.readBuffer(suffixHead + 20L, elemSize);
            Long newChainAddress = OffHeapChainStorageEngine.this.createAttachedChain(OffHeapChainStorageEngine.this.readKeyBuffer(this.chain), hash, elemBuffer);
            if (newChainAddress == null) {
                return false;
            }
            try (AttachedInternalChain newChain = new AttachedInternalChain(newChainAddress);){
                long next = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
                long tail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
                if (next != this.chain) {
                    newChain.append(next, tail);
                }
                if (OffHeapChainStorageEngine.this.owner.updateEncoding(hash, this.chain, newChainAddress.longValue(), -1L)) {
                    OffHeapChainStorageEngine.this.storage.writeLong(prefixTail + 12L, this.chain);
                    this.free();
                    boolean bl = true;
                    return bl;
                }
                newChain.free();
                throw new AssertionError((Object)"Encoding update failure - impossible!");
            }
        }

        public boolean replaceHeader(Chain expected, Chain replacement) {
            long prefixTail;
            long suffixHead = this.chain + 16L;
            Iterator expectedIt = expected.iterator();
            do {
                if (!this.compare((Element)expectedIt.next(), suffixHead)) {
                    return true;
                }
                prefixTail = suffixHead;
                suffixHead = OffHeapChainStorageEngine.this.storage.readLong(suffixHead + 12L);
            } while (expectedIt.hasNext());
            int hash = OffHeapChainStorageEngine.this.readKeyHash(this.chain);
            Long newChainAddress = OffHeapChainStorageEngine.this.createAttachedChain(OffHeapChainStorageEngine.this.readKeyBuffer(this.chain), hash, replacement);
            if (newChainAddress == null) {
                return false;
            }
            try (AttachedInternalChain newChain = new AttachedInternalChain(newChainAddress);){
                if (suffixHead != this.chain) {
                    newChain.append(suffixHead, OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L));
                }
                if (OffHeapChainStorageEngine.this.owner.updateEncoding(hash, this.chain, newChainAddress.longValue(), -1L)) {
                    OffHeapChainStorageEngine.this.storage.writeLong(prefixTail + 12L, this.chain);
                    this.free();
                    boolean bl = true;
                    return bl;
                }
                newChain.free();
                throw new AssertionError((Object)"Encoding update failure - impossible!");
            }
        }

        private void free() {
            long element = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 16L + 12L);
            OffHeapChainStorageEngine.this.storage.free(this.chain);
            while (element != this.chain) {
                long next = OffHeapChainStorageEngine.this.storage.readLong(element + 12L);
                OffHeapChainStorageEngine.this.storage.free(element);
                element = next;
            }
        }

        private long createElement(ByteBuffer element) {
            long newElement = OffHeapChainStorageEngine.this.storage.allocate((long)(element.remaining() + 20));
            if (newElement < 0L) {
                return newElement;
            }
            OffHeapChainStorageEngine.this.writeElement(newElement, element);
            return newElement;
        }

        private boolean compare(Element element, long address) {
            if (element instanceof SequencedElement) {
                return this.readElementSequenceNumber(address) == ((SequencedElement)element).getSequenceNumber();
            }
            return this.readElementBuffer(address).equals(element.getPayload());
        }

        private void append(long head, long tail) {
            long oldTail = OffHeapChainStorageEngine.this.storage.readLong(this.chain + 8L);
            OffHeapChainStorageEngine.this.storage.writeLong(oldTail + 12L, head);
            OffHeapChainStorageEngine.this.storage.writeLong(tail + 12L, this.chain);
            OffHeapChainStorageEngine.this.storage.writeLong(this.chain + 8L, tail);
        }

        private Element element(ByteBuffer attachedBuffer, final long sequence) {
            final ByteBuffer detachedBuffer = (ByteBuffer)ByteBuffer.allocate(attachedBuffer.remaining()).put(attachedBuffer).flip();
            return new SequencedElement(){

                public ByteBuffer getPayload() {
                    return detachedBuffer.asReadOnlyBuffer();
                }

                public long getSequenceNumber() {
                    return sequence;
                }
            };
        }

        private ByteBuffer readElementBuffer(long address) {
            int elemLength = OffHeapChainStorageEngine.this.storage.readInt(address + 8L);
            return OffHeapChainStorageEngine.this.storage.readBuffer(address + 20L, elemLength);
        }

        private long readElementSequenceNumber(long address) {
            return OffHeapChainStorageEngine.this.storage.readLong(address + 0L);
        }

        public void moved(long from, long to) {
            if (from == this.chain) {
                this.chain = to;
            }
        }

        @Override
        public void close() {
            OffHeapChainStorageEngine.this.activeChains.remove(this);
        }
    }

    private static class PrimordialChain
    implements InternalChain {
        private final ByteBuffer element;

        public PrimordialChain(ByteBuffer element) {
            this.element = element;
        }

        @Override
        public Chain detach() {
            throw new AssertionError((Object)"primordial chains cannot be detached");
        }

        @Override
        public boolean append(ByteBuffer element) {
            throw new AssertionError((Object)"primordial chains cannot be appended");
        }

        @Override
        public boolean replace(Chain expected, Chain replacement) {
            throw new AssertionError((Object)"primordial chains cannot be mutated");
        }

        @Override
        public void close() {
        }
    }

    private static class DetachedChain
    implements Chain {
        private final List<Element> elements;

        private DetachedChain(List<Element> buffers) {
            this.elements = Collections.unmodifiableList(buffers);
        }

        public Iterator<Element> reverseIterator() {
            return Util.reverseIterator(this.elements);
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public Iterator<Element> iterator() {
            return this.elements.iterator();
        }
    }
}

