/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ServerStore;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerStoreEvictionListener;
import org.ehcache.clustered.server.offheap.LongPortability;
import org.ehcache.clustered.server.offheap.OffHeapChainMap;
import org.ehcache.clustered.server.state.ResourcePageSource;
import org.terracotta.offheapstore.MapInternals;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.util.MemoryUnit;

public class OffHeapServerStore
implements ServerStore,
MapInternals {
    private static final long MAX_PAGE_SIZE_IN_KB = MemoryUnit.KILOBYTES.convert(8L, MemoryUnit.MEGABYTES);
    private final List<OffHeapChainMap<Long>> segments;
    private final KeySegmentMapper mapper;

    OffHeapServerStore(PageSource source, KeySegmentMapper mapper) {
        this.mapper = mapper;
        this.segments = new ArrayList<OffHeapChainMap<Long>>(mapper.getSegments());
        for (int i = 0; i < mapper.getSegments(); ++i) {
            this.segments.add(new OffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), MemoryUnit.MEGABYTES.toBytes(8), false));
        }
    }

    public OffHeapServerStore(ResourcePageSource source, KeySegmentMapper mapper) {
        this.mapper = mapper;
        this.segments = new ArrayList<OffHeapChainMap<Long>>(mapper.getSegments());
        long maxSize = OffHeapServerStore.getMaxSize(source.getPool().getSize());
        for (int i = 0; i < mapper.getSegments(); ++i) {
            this.segments.add(new OffHeapChainMap<Long>(source, LongPortability.INSTANCE, MemoryUnit.KILOBYTES.toBytes(4), (int)MemoryUnit.KILOBYTES.toBytes(maxSize), false));
        }
    }

    public List<OffHeapChainMap<Long>> getSegments() {
        return this.segments;
    }

    static long getMaxSize(long poolSize) {
        long l = Long.highestOneBit(poolSize);
        long sizeInKb = MemoryUnit.KILOBYTES.convert(l, MemoryUnit.BYTES);
        long maxSize = sizeInKb >> 5;
        if (maxSize >= MAX_PAGE_SIZE_IN_KB) {
            maxSize = MAX_PAGE_SIZE_IN_KB;
        }
        return maxSize;
    }

    public void setEvictionListener(final ServerStoreEvictionListener listener) {
        OffHeapChainMap.ChainMapEvictionListener<Long> chainMapEvictionListener = new OffHeapChainMap.ChainMapEvictionListener<Long>(){

            @Override
            public void onEviction(Long key) {
                listener.onEviction(key);
            }
        };
        for (OffHeapChainMap<Long> segment : this.segments) {
            segment.setEvictionListener(chainMapEvictionListener);
        }
    }

    public Chain get(long key) {
        return this.segmentFor(key).get(key);
    }

    public void append(long key, ByteBuffer payLoad) {
        try {
            this.segmentFor(key).append(key, payLoad);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key)) {
                try {
                    this.segmentFor(key).append(key, payLoad);
                    return;
                }
                catch (OversizeMappingException oversizeMappingException) {
                    // empty catch block
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    this.segmentFor(key).append(key, payLoad);
                    return;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key)) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public Chain getAndAppend(long key, ByteBuffer payLoad) {
        try {
            return this.segmentFor(key).getAndAppend(key, payLoad);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key)) {
                try {
                    return this.segmentFor(key).getAndAppend(key, payLoad);
                }
                catch (OversizeMappingException oversizeMappingException) {
                    // empty catch block
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    Chain chain = this.segmentFor(key).getAndAppend(key, payLoad);
                    return chain;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key)) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.segmentFor(key).replaceAtHead(key, expect, update);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key)) {
                try {
                    this.segmentFor(key).replaceAtHead(key, expect, update);
                    return;
                }
                catch (OversizeMappingException oversizeMappingException) {
                    // empty catch block
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    this.segmentFor(key).replaceAtHead(key, expect, update);
                    return;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key)) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public void put(long key, Chain chain) {
        try {
            this.segmentFor(key).put(key, chain);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key)) {
                try {
                    this.segmentFor(key).put(key, chain);
                }
                catch (OversizeMappingException oversizeMappingException) {
                    // empty catch block
                }
            }
            this.writeLockAll();
            try {
                do {
                    try {
                        this.segmentFor(key).put(key, chain);
                    }
                    catch (OversizeMappingException ex) {
                        e = ex;
                    }
                } while (this.handleOversizeMappingException(key));
                throw e;
            }
            catch (Throwable throwable) {
                this.writeUnlockAll();
                throw throwable;
            }
        }
    }

    public void clear() {
        for (OffHeapChainMap<Long> segment : this.segments) {
            segment.clear();
        }
    }

    OffHeapChainMap<Long> segmentFor(long key) {
        return this.segments.get(this.mapper.getSegmentForKey(key));
    }

    private void writeLockAll() {
        for (OffHeapChainMap<Long> s : this.segments) {
            s.writeLock().lock();
        }
    }

    private void writeUnlockAll() {
        for (OffHeapChainMap<Long> s : this.segments) {
            s.writeLock().unlock();
        }
    }

    boolean handleOversizeMappingException(long hash) {
        boolean evicted = false;
        OffHeapChainMap<Long> target = this.segmentFor(hash);
        for (OffHeapChainMap<Long> s : this.segments) {
            if (s == target) continue;
            evicted |= s.shrink();
        }
        return evicted;
    }

    public void close() {
        this.writeLockAll();
        try {
            this.clear();
        }
        finally {
            this.writeUnlockAll();
        }
        this.segments.clear();
    }

    public long getAllocatedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getAllocatedMemory();
        }
        return total;
    }

    public long getOccupiedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getOccupiedMemory();
        }
        return total;
    }

    public long getDataAllocatedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataAllocatedMemory();
        }
        return total;
    }

    public long getDataOccupiedMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataOccupiedMemory();
        }
        return total;
    }

    public long getDataSize() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataSize();
        }
        return total;
    }

    public long getSize() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getSize();
        }
        return total;
    }

    public long getTableCapacity() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getTableCapacity();
        }
        return total;
    }

    public long getUsedSlotCount() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getUsedSlotCount();
        }
        return total;
    }

    public long getRemovedSlotCount() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getRemovedSlotCount();
        }
        return total;
    }

    public int getReprobeLength() {
        int total = 0;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getReprobeLength();
        }
        return total;
    }

    public long getVitalMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getVitalMemory();
        }
        return total;
    }

    public long getDataVitalMemory() {
        long total = 0L;
        for (MapInternals mapInternals : this.segments) {
            total += mapInternals.getDataVitalMemory();
        }
        return total;
    }
}

