/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.clustered.server.state.ClientMessageTracker;
import org.ehcache.clustered.server.state.MessageTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientMessageTracker
implements ClientMessageTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientMessageTracker.class);
    private final Map<UUID, MessageTracker> clientUUIDMessageTrackerMap = new ConcurrentHashMap<UUID, MessageTracker>();
    private volatile boolean track = true;

    @Override
    public void stopTracking() {
        this.track = false;
    }

    @Override
    public void applied(long msgId, UUID clientId) {
        if (this.track) {
            MessageTracker messageTracker = this.clientUUIDMessageTrackerMap.computeIfAbsent(clientId, uuid -> new MessageTracker());
            messageTracker.track(msgId);
        }
    }

    @Override
    public boolean isDuplicate(long msgId, UUID clientId) {
        if (this.clientUUIDMessageTrackerMap.get(clientId) == null) {
            return false;
        }
        return this.clientUUIDMessageTrackerMap.get(clientId).seen(msgId);
    }

    @Override
    public void remove(UUID clientId) {
        this.clientUUIDMessageTrackerMap.remove(clientId);
        LOGGER.info("Stop tracking client {}.", (Object)clientId);
    }

    @Override
    public void reconcileTrackedClients(Collection<UUID> trackedClients) {
        this.clientUUIDMessageTrackerMap.keySet().retainAll(trackedClients);
    }

    @Override
    public void clear() {
        this.clientUUIDMessageTrackerMap.clear();
    }
}

