/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.LongStream;

public class MessageTracker {
    private volatile long highestContiguousMsgId = -1L;
    private final Set<Long> nonContiguousMsgIds = ConcurrentHashMap.newKeySet();
    private final Lock reconciliationLock = new ReentrantLock();

    public void track(long msgId) {
        this.nonContiguousMsgIds.add(msgId);
        this.tryReconcile();
    }

    public boolean seen(long msgId) {
        boolean seen = msgId <= this.highestContiguousMsgId || this.nonContiguousMsgIds.contains(msgId);
        this.tryReconcile();
        return seen;
    }

    public boolean isEmpty() {
        return this.nonContiguousMsgIds.isEmpty();
    }

    private void reconcile() {
        long msgId;
        ArrayList<Long> contiguousMsgIds = new ArrayList<Long>();
        Iterator iterator = ((Iterable)() -> LongStream.iterate(this.highestContiguousMsgId + 1L, id -> id + 1L).iterator()).iterator();
        while (iterator.hasNext() && this.nonContiguousMsgIds.contains(msgId = ((Long)iterator.next()).longValue())) {
            contiguousMsgIds.add(msgId);
        }
        if (contiguousMsgIds.isEmpty()) {
            return;
        }
        this.highestContiguousMsgId = (Long)contiguousMsgIds.get(contiguousMsgIds.size() - 1);
        this.nonContiguousMsgIds.removeAll(contiguousMsgIds);
    }

    private void tryReconcile() {
        if (!this.reconciliationLock.tryLock()) {
            return;
        }
        try {
            this.reconcile();
        }
        finally {
            this.reconciliationLock.unlock();
        }
    }
}

