/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import com.tc.classloader.CommonComponent;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.terracotta.offheapstore.buffersource.BufferSource;
import org.terracotta.offheapstore.buffersource.OffHeapBufferSource;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.Page;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.util.MemoryUnit;

@CommonComponent
public class ResourcePageSource
implements PageSource {
    private final ServerSideConfiguration.Pool pool;
    private final UpfrontAllocatingPageSource delegatePageSource;

    public ResourcePageSource(ServerSideConfiguration.Pool pool) {
        this.pool = pool;
        this.delegatePageSource = new UpfrontAllocatingPageSource((BufferSource)new OffHeapBufferSource(), pool.getSize(), MemoryUnit.GIGABYTES.toBytes(1), MemoryUnit.MEGABYTES.toBytes(128));
    }

    public ServerSideConfiguration.Pool getPool() {
        return this.pool;
    }

    public long getAllocatedSize() {
        return this.delegatePageSource.getAllocatedSizeUnSync();
    }

    public Page allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        return this.delegatePageSource.allocate(size, thief, victim, owner);
    }

    public void free(Page page) {
        this.delegatePageSource.free(page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourcePageSource{");
        sb.append("pool=").append(this.pool);
        sb.append(", delegatePageSource=").append(this.delegatePageSource);
        sb.append('}');
        return sb.toString();
    }
}

