/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.InvalidOperationException;
import org.ehcache.clustered.common.internal.exceptions.InvalidStoreException;
import org.ehcache.clustered.common.internal.exceptions.LifecycleException;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponseFactory;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ReconnectMessageCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.server.CommunicatorServiceConfiguration;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.ServerStoreCompatibility;
import org.ehcache.clustered.server.internal.messages.EhcacheDataSyncMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.server.management.ClusterTierClientState;
import org.ehcache.clustered.server.management.ClusterTierManagement;
import org.ehcache.clustered.server.state.ClientMessageTracker;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.InvalidationTracker;
import org.ehcache.clustered.server.state.config.EhcacheStoreStateServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;

public class ClusterTierActiveEntity
implements ActiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierActiveEntity.class);
    static final String SYNC_DATA_SIZE_PROP = "ehcache.sync.data.size.threshold";
    private static final long DEFAULT_SYNC_DATA_SIZE_THRESHOLD = 0x400000L;
    private final String storeIdentifier;
    private final ServerStoreConfiguration configuration;
    private final EhcacheEntityResponseFactory responseFactory;
    private final ClientCommunicator clientCommunicator;
    private final EhcacheStateService stateService;
    private final IEntityMessenger entityMessenger;
    private final ServerStoreCompatibility storeCompatibility = new ServerStoreCompatibility();
    private final ConcurrentMap<ClientDescriptor, ClusterTierClientState> connectedClients = new ConcurrentHashMap<ClientDescriptor, ClusterTierClientState>();
    private final AtomicBoolean reconnectComplete = new AtomicBoolean(true);
    private final AtomicInteger invalidationIdGenerator = new AtomicInteger();
    private final ConcurrentMap<Integer, InvalidationHolder> clientsWaitingForInvalidation = new ConcurrentHashMap<Integer, InvalidationHolder>();
    private final ReconnectMessageCodec reconnectMessageCodec = new ReconnectMessageCodec();
    private final ClusterTierManagement management;
    private final Object inflightInvalidationsMutex = new Object();
    private volatile List<InvalidationTuple> inflightInvalidations;

    public ClusterTierActiveEntity(ServiceRegistry registry, ClusterTierEntityConfiguration entityConfiguration, KeySegmentMapper defaultMapper) throws ConfigurationException {
        if (entityConfiguration == null) {
            throw new ConfigurationException("ClusteredStoreEntityConfiguration cannot be null");
        }
        this.storeIdentifier = entityConfiguration.getStoreIdentifier();
        this.configuration = entityConfiguration.getConfiguration();
        this.responseFactory = new EhcacheEntityResponseFactory();
        this.clientCommunicator = (ClientCommunicator)registry.getService((ServiceConfiguration)new CommunicatorServiceConfiguration());
        this.stateService = (EhcacheStateService)registry.getService((ServiceConfiguration)new EhcacheStoreStateServiceConfig(entityConfiguration.getManagerIdentifier(), defaultMapper));
        this.entityMessenger = (IEntityMessenger)registry.getService((ServiceConfiguration)new BasicServiceConfiguration(IEntityMessenger.class));
        if (this.entityMessenger == null) {
            throw new AssertionError((Object)"Server failed to retrieve IEntityMessenger service.");
        }
        this.management = new ClusterTierManagement(registry, this.stateService, true, this.storeIdentifier, entityConfiguration.getManagerIdentifier());
    }

    public void createNew() throws ConfigurationException {
        ServerSideServerStore store = this.stateService.createStore(this.storeIdentifier, this.configuration, true);
        store.setEvictionListener(this::invalidateHashAfterEviction);
        this.management.init();
    }

    List<InvalidationTuple> getInflightInvalidations() {
        return this.inflightInvalidations;
    }

    public void loadExisting() {
        this.inflightInvalidations = new ArrayList<InvalidationTuple>();
        if (!this.isStrong()) {
            LOGGER.debug("Preparing for handling inflight invalidations");
            this.addInflightInvalidationsForEventualCaches();
        }
        this.stateService.loadStore(this.storeIdentifier, this.configuration).setEvictionListener(this::invalidateHashAfterEviction);
        this.reconnectComplete.set(false);
        this.management.init();
    }

    private void invalidateHashAfterEviction(long key) {
        Set<ClientDescriptor> clientsToInvalidate = Collections.newSetFromMap(new ConcurrentHashMap());
        clientsToInvalidate.addAll(this.getAttachedClients());
        for (ClientDescriptor clientDescriptorThatHasToInvalidate : clientsToInvalidate) {
            LOGGER.debug("SERVER: eviction happened; asking client {} to invalidate hash {} from cache {}", new Object[]{clientDescriptorThatHasToInvalidate, key, this.storeIdentifier});
            try {
                this.clientCommunicator.sendNoResponse(clientDescriptorThatHasToInvalidate, (EntityResponse)EhcacheEntityResponse.serverInvalidateHash((long)key));
            }
            catch (MessageCodecException mce) {
                throw new AssertionError("Codec error", mce);
            }
        }
    }

    public void connected(ClientDescriptor clientDescriptor) {
        ClusterTierClientState clientState = new ClusterTierClientState(this.storeIdentifier, false);
        if (this.connectedClients.putIfAbsent(clientDescriptor, clientState) == null) {
            this.management.clientConnected(clientDescriptor, clientState);
        }
    }

    public void disconnected(ClientDescriptor clientDescriptor) {
        Set invalidationIds = this.clientsWaitingForInvalidation.keySet();
        for (Integer invalidationId : invalidationIds) {
            this.clientInvalidated(clientDescriptor, invalidationId);
        }
        Iterator it = this.clientsWaitingForInvalidation.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ClientDescriptor clientDescriptorWaitingForInvalidation = ((InvalidationHolder)next.getValue()).clientDescriptorWaitingForInvalidation;
            if (clientDescriptorWaitingForInvalidation == null || !clientDescriptorWaitingForInvalidation.equals(clientDescriptor)) continue;
            it.remove();
        }
        ClusterTierClientState clientState = (ClusterTierClientState)this.connectedClients.remove(clientDescriptor);
        if (clientState != null) {
            this.management.clientDisconnected(clientDescriptor, clientState);
            UUID clientId = clientState.getClientIdentifier();
            if (clientId != null) {
                try {
                    this.entityMessenger.messageSelf((EntityMessage)new PassiveReplicationMessage.ClientIDTrackerMessage(clientId));
                }
                catch (MessageCodecException mce) {
                    throw new AssertionError("Codec error", mce);
                }
                ClientMessageTracker messageTracker = this.stateService.getClientMessageTracker(this.storeIdentifier);
                if (messageTracker != null) {
                    messageTracker.remove(clientId);
                }
            }
        }
    }

    public EhcacheEntityResponse invoke(ClientDescriptor clientDescriptor, EhcacheEntityMessage message) {
        this.clearClientTrackedAtReconnectComplete();
        try {
            if (message instanceof EhcacheOperationMessage) {
                EhcacheOperationMessage operationMessage = (EhcacheOperationMessage)message;
                EhcacheMessageType messageType = operationMessage.getMessageType();
                if (EhcacheMessageType.isStoreOperationMessage((EhcacheMessageType)messageType)) {
                    return this.invokeServerStoreOperation(clientDescriptor, (ServerStoreOpMessage)message);
                }
                if (EhcacheMessageType.isLifecycleMessage((EhcacheMessageType)messageType)) {
                    return this.invokeLifeCycleOperation(clientDescriptor, (LifecycleMessage)message);
                }
                if (EhcacheMessageType.isStateRepoOperationMessage((EhcacheMessageType)messageType)) {
                    return this.invokeStateRepositoryOperation((StateRepositoryOpMessage)message);
                }
            }
            throw new AssertionError((Object)("Unsupported message : " + message.getClass()));
        }
        catch (ClusterException e) {
            return this.responseFactory.failure(e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
            return this.responseFactory.failure((ClusterException)new InvalidOperationException((Throwable)e));
        }
    }

    private EhcacheEntityResponse invokeStateRepositoryOperation(StateRepositoryOpMessage message) throws ClusterException {
        EhcacheEntityResponse response = this.stateService.getStateRepositoryManager().invoke(message);
        this.trackMessage((EhcacheOperationMessage)message);
        return response;
    }

    private EhcacheEntityResponse invokeLifeCycleOperation(ClientDescriptor clientDescriptor, LifecycleMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case VALIDATE_SERVER_STORE: {
                this.validateServerStore(clientDescriptor, (LifecycleMessage.ValidateServerStore)message);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported LifeCycle operation " + message));
            }
        }
        return this.responseFactory.success();
    }

    private void validateServerStore(ClientDescriptor clientDescriptor, LifecycleMessage.ValidateServerStore validateServerStore) throws ClusterException {
        ClusterTierClientState clientState = (ClusterTierClientState)this.connectedClients.get(clientDescriptor);
        if (clientState == null) {
            throw new AssertionError((Object)("Client " + clientDescriptor + " trying to reconnect is not connected to entity"));
        }
        if (clientState.isAttached()) {
            throw new LifecycleException("Client : " + clientDescriptor + " is already being tracked with Client ID : " + clientState.getClientIdentifier());
        }
        ServerStoreConfiguration clientConfiguration = validateServerStore.getStoreConfiguration();
        LOGGER.info("Client {} validating cluster tier '{}'", (Object)clientDescriptor, (Object)this.storeIdentifier);
        ServerSideServerStore store = this.stateService.getStore(this.storeIdentifier);
        if (store == null) {
            throw new InvalidStoreException("cluster tier '" + this.storeIdentifier + "' does not exist");
        }
        this.storeCompatibility.verify(store.getStoreConfiguration(), clientConfiguration);
        this.attachStore(clientDescriptor, validateServerStore.getClientId());
        this.management.clientValidated(clientDescriptor, (ClusterTierClientState)this.connectedClients.get(clientDescriptor));
    }

    private void attachStore(ClientDescriptor clientDescriptor, UUID clientId) {
        ClusterTierClientState clientState = new ClusterTierClientState(this.storeIdentifier, true, clientId);
        this.connectedClients.replace(clientDescriptor, clientState);
        LOGGER.info("Client: {} with client ID: {} attached to cluster tier '{}'", (Object)clientDescriptor, (Object)this.storeIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EhcacheEntityResponse invokeServerStoreOperation(ClientDescriptor clientDescriptor, ServerStoreOpMessage message) throws ClusterException {
        ServerSideServerStore cacheStore = this.stateService.getStore(this.storeIdentifier);
        if (cacheStore == null) {
            throw new LifecycleException("cluster tier does not exist : '" + this.storeIdentifier + "'");
        }
        ClusterTierClientState clientState = (ClusterTierClientState)this.connectedClients.get(clientDescriptor);
        if (clientState == null || !clientState.isAttached()) {
            throw new LifecycleException("Client not attached to cluster tier '" + this.storeIdentifier + "'");
        }
        if (this.inflightInvalidations != null) {
            Object object = this.inflightInvalidationsMutex;
            synchronized (object) {
                if (this.inflightInvalidations != null) {
                    List<InvalidationTuple> tmpInflightInvalidations = this.inflightInvalidations;
                    this.inflightInvalidations = null;
                    LOGGER.debug("Stalling all operations for cluster tier {} for firing inflight invalidations again.", (Object)this.storeIdentifier);
                    tmpInflightInvalidations.forEach(invalidationState -> {
                        if (invalidationState.isClearInProgress()) {
                            this.invalidateAll(invalidationState.getClientDescriptor());
                        }
                        invalidationState.getInvalidationsInProgress().forEach(hashInvalidationToBeResent -> this.invalidateHashForClient(invalidationState.getClientDescriptor(), (long)hashInvalidationToBeResent));
                    });
                }
            }
        }
        switch (message.getMessageType()) {
            case GET_STORE: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                try {
                    return this.responseFactory.response(cacheStore.get(getMessage.getKey()));
                }
                catch (TimeoutException e) {
                    throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                }
            }
            case APPEND: {
                InvalidationTracker invalidationTracker;
                if (!this.isMessageDuplicate((EhcacheEntityMessage)message)) {
                    Chain newChain;
                    ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                    this.trackMessage((EhcacheOperationMessage)message);
                    invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
                    if (invalidationTracker != null) {
                        invalidationTracker.trackHashInvalidation(appendMessage.getKey());
                    }
                    try {
                        cacheStore.append(appendMessage.getKey(), appendMessage.getPayload());
                        newChain = cacheStore.get(appendMessage.getKey());
                    }
                    catch (TimeoutException e) {
                        throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                    }
                    this.sendMessageToSelfAndDeferRetirement((ServerStoreOpMessage.KeyBasedServerStoreOpMessage)appendMessage, newChain);
                    this.invalidateHashForClient(clientDescriptor, appendMessage.getKey());
                }
                return this.responseFactory.success();
            }
            case GET_AND_APPEND: {
                InvalidationTracker invalidationTracker;
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                LOGGER.trace("Message {} : GET_AND_APPEND on key {} from client {}", new Object[]{message, getAndAppendMessage.getKey(), getAndAppendMessage.getClientId()});
                if (!this.isMessageDuplicate((EhcacheEntityMessage)message)) {
                    Chain newChain;
                    Chain result;
                    LOGGER.trace("Message {} : is not duplicate", (Object)message);
                    this.trackMessage((EhcacheOperationMessage)message);
                    invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
                    if (invalidationTracker != null) {
                        invalidationTracker.trackHashInvalidation(getAndAppendMessage.getKey());
                    }
                    try {
                        result = cacheStore.getAndAppend(getAndAppendMessage.getKey(), getAndAppendMessage.getPayload());
                        newChain = cacheStore.get(getAndAppendMessage.getKey());
                    }
                    catch (TimeoutException e) {
                        throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                    }
                    this.sendMessageToSelfAndDeferRetirement((ServerStoreOpMessage.KeyBasedServerStoreOpMessage)getAndAppendMessage, newChain);
                    LOGGER.debug("Send invalidations for key {}", (Object)getAndAppendMessage.getKey());
                    this.invalidateHashForClient(clientDescriptor, getAndAppendMessage.getKey());
                    return this.responseFactory.response(result);
                }
                try {
                    return this.responseFactory.response(cacheStore.get(getAndAppendMessage.getKey()));
                }
                catch (TimeoutException e) {
                    throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                }
            }
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                cacheStore.replaceAtHead(replaceAtHeadMessage.getKey(), replaceAtHeadMessage.getExpect(), replaceAtHeadMessage.getUpdate());
                return this.responseFactory.success();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAck = (ServerStoreOpMessage.ClientInvalidationAck)message;
                int invalidationId = clientInvalidationAck.getInvalidationId();
                LOGGER.debug("SERVER: got notification of invalidation ack in cache {} from {} (ID {})", new Object[]{this.storeIdentifier, clientDescriptor, invalidationId});
                this.clientInvalidated(clientDescriptor, invalidationId);
                return this.responseFactory.success();
            }
            case CLIENT_INVALIDATION_ALL_ACK: {
                ServerStoreOpMessage.ClientInvalidationAllAck clientInvalidationAllAck = (ServerStoreOpMessage.ClientInvalidationAllAck)message;
                int invalidationId = clientInvalidationAllAck.getInvalidationId();
                LOGGER.debug("SERVER: got notification of invalidation ack in cache {} from {} (ID {})", new Object[]{this.storeIdentifier, clientDescriptor, invalidationId});
                this.clientInvalidated(clientDescriptor, invalidationId);
                return this.responseFactory.success();
            }
            case CLEAR: {
                if (!this.isMessageDuplicate((EhcacheEntityMessage)message)) {
                    LOGGER.info("Clearing cluster tier {}", (Object)this.storeIdentifier);
                    try {
                        cacheStore.clear();
                    }
                    catch (TimeoutException e) {
                        throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                    }
                    this.trackMessage((EhcacheOperationMessage)message);
                    InvalidationTracker invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
                    if (invalidationTracker != null) {
                        invalidationTracker.setClearInProgress(true);
                    }
                    this.invalidateAll(clientDescriptor);
                }
                return this.responseFactory.success();
            }
        }
        throw new AssertionError((Object)("Unsupported ServerStore operation : " + message));
    }

    private void invalidateAll(ClientDescriptor originatingClientDescriptor) {
        int invalidationId = this.invalidationIdGenerator.getAndIncrement();
        Set<ClientDescriptor> clientsToInvalidate = Collections.newSetFromMap(new ConcurrentHashMap());
        clientsToInvalidate.addAll(this.getAttachedClients());
        if (originatingClientDescriptor != null) {
            clientsToInvalidate.remove(originatingClientDescriptor);
        }
        InvalidationHolder invalidationHolder = new InvalidationHolder(originatingClientDescriptor, clientsToInvalidate);
        this.clientsWaitingForInvalidation.put(invalidationId, invalidationHolder);
        LOGGER.debug("SERVER: requesting {} client(s) invalidation of all in cache {} (ID {})", new Object[]{clientsToInvalidate.size(), this.storeIdentifier, invalidationId});
        for (ClientDescriptor clientDescriptorThatHasToInvalidate : clientsToInvalidate) {
            LOGGER.debug("SERVER: asking client {} to invalidate all from cache {} (ID {})", new Object[]{clientDescriptorThatHasToInvalidate, this.storeIdentifier, invalidationId});
            try {
                this.clientCommunicator.sendNoResponse(clientDescriptorThatHasToInvalidate, (EntityResponse)EhcacheEntityResponse.clientInvalidateAll((int)invalidationId));
            }
            catch (MessageCodecException mce) {
                throw new AssertionError("Codec error", mce);
            }
        }
        if (clientsToInvalidate.isEmpty()) {
            this.clientInvalidated(invalidationHolder.clientDescriptorWaitingForInvalidation, invalidationId);
        }
    }

    private void clientInvalidated(ClientDescriptor clientDescriptor, int invalidationId) {
        InvalidationHolder invalidationHolder = (InvalidationHolder)this.clientsWaitingForInvalidation.get(invalidationId);
        if (invalidationHolder == null) {
            LOGGER.debug("Ignoring invalidation from client {} " + clientDescriptor);
            return;
        }
        invalidationHolder.clientsHavingToInvalidate.remove(clientDescriptor);
        if (invalidationHolder.clientsHavingToInvalidate.isEmpty() && this.clientsWaitingForInvalidation.remove(invalidationId) != null) {
            try {
                Long key = invalidationHolder.key;
                if (key == null) {
                    if (this.isStrong()) {
                        this.clientCommunicator.sendNoResponse(invalidationHolder.clientDescriptorWaitingForInvalidation, (EntityResponse)EhcacheEntityResponse.allInvalidationDone());
                        LOGGER.debug("SERVER: notifying originating client that all other clients invalidated all in cache {} from {} (ID {})", new Object[]{this.storeIdentifier, clientDescriptor, invalidationId});
                    } else {
                        this.entityMessenger.messageSelf((EntityMessage)new PassiveReplicationMessage.ClearInvalidationCompleteMessage());
                        InvalidationTracker invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
                        if (invalidationTracker != null) {
                            invalidationTracker.setClearInProgress(false);
                        }
                    }
                } else if (this.isStrong()) {
                    this.clientCommunicator.sendNoResponse(invalidationHolder.clientDescriptorWaitingForInvalidation, (EntityResponse)EhcacheEntityResponse.hashInvalidationDone((long)key));
                    LOGGER.debug("SERVER: notifying originating client that all other clients invalidated key {} in cache {} from {} (ID {})", new Object[]{key, this.storeIdentifier, clientDescriptor, invalidationId});
                } else {
                    this.entityMessenger.messageSelf((EntityMessage)new PassiveReplicationMessage.InvalidationCompleteMessage(key));
                    InvalidationTracker invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
                    if (invalidationTracker != null) {
                        invalidationTracker.untrackHashInvalidation(key);
                    }
                }
            }
            catch (MessageCodecException mce) {
                throw new AssertionError("Codec error", mce);
            }
        }
    }

    private void invalidateHashForClient(ClientDescriptor originatingClientDescriptor, long key) {
        int invalidationId = this.invalidationIdGenerator.getAndIncrement();
        Set<ClientDescriptor> clientsToInvalidate = Collections.newSetFromMap(new ConcurrentHashMap());
        clientsToInvalidate.addAll(this.getAttachedClients());
        if (originatingClientDescriptor != null) {
            clientsToInvalidate.remove(originatingClientDescriptor);
        }
        InvalidationHolder invalidationHolder = new InvalidationHolder(originatingClientDescriptor, clientsToInvalidate, key);
        this.clientsWaitingForInvalidation.put(invalidationId, invalidationHolder);
        LOGGER.debug("SERVER: requesting {} client(s) invalidation of hash {} in cache {} (ID {})", new Object[]{clientsToInvalidate.size(), key, this.storeIdentifier, invalidationId});
        for (ClientDescriptor clientDescriptorThatHasToInvalidate : clientsToInvalidate) {
            LOGGER.debug("SERVER: asking client {} to invalidate hash {} from cache {} (ID {})", new Object[]{clientDescriptorThatHasToInvalidate, key, this.storeIdentifier, invalidationId});
            try {
                this.clientCommunicator.sendNoResponse(clientDescriptorThatHasToInvalidate, (EntityResponse)EhcacheEntityResponse.clientInvalidateHash((long)key, (int)invalidationId));
            }
            catch (MessageCodecException mce) {
                throw new AssertionError("Codec error", mce);
            }
        }
        if (clientsToInvalidate.isEmpty()) {
            this.clientInvalidated(invalidationHolder.clientDescriptorWaitingForInvalidation, invalidationId);
        }
    }

    private void trackMessage(EhcacheOperationMessage message) {
        ClientMessageTracker clientMessageTracker = this.stateService.getClientMessageTracker(this.storeIdentifier);
        if (clientMessageTracker != null) {
            clientMessageTracker.applied(message.getId(), message.getClientId());
        }
    }

    private boolean isMessageDuplicate(EhcacheEntityMessage message) {
        ClientMessageTracker clientMessageTracker = this.stateService.getClientMessageTracker(this.storeIdentifier);
        if (clientMessageTracker != null) {
            return clientMessageTracker.isDuplicate(message.getId(), message.getClientId());
        }
        return false;
    }

    private void sendMessageToSelfAndDeferRetirement(ServerStoreOpMessage.KeyBasedServerStoreOpMessage message, Chain result) {
        try {
            this.entityMessenger.messageSelfAndDeferRetirement((EntityMessage)message, (EntityMessage)new PassiveReplicationMessage.ChainReplicationMessage(message.getKey(), result, message.getId(), message.getClientId()));
        }
        catch (MessageCodecException e) {
            throw new AssertionError("Codec error", e);
        }
    }

    private void addInflightInvalidationsForEventualCaches() {
        InvalidationTracker invalidationTracker = this.stateService.getInvalidationTracker(this.storeIdentifier);
        if (invalidationTracker != null) {
            this.inflightInvalidations.add(new InvalidationTuple(null, invalidationTracker.getTrackedKeys(), invalidationTracker.isClearInProgress()));
            invalidationTracker.clear();
        }
    }

    public void handleReconnect(ClientDescriptor clientDescriptor, byte[] extendedReconnectData) {
        if (this.inflightInvalidations == null) {
            throw new AssertionError((Object)"Load existing was not invoked before handleReconnect");
        }
        if (this.connectedClients.get(clientDescriptor) == null) {
            throw new AssertionError((Object)("Client " + clientDescriptor + " trying to reconnect is not connected to entity"));
        }
        ClusterTierReconnectMessage reconnectMessage = this.reconnectMessageCodec.decode(extendedReconnectData);
        ServerSideServerStore serverStore = this.stateService.getStore(this.storeIdentifier);
        this.addInflightInvalidationsForStrongCache(clientDescriptor, reconnectMessage, serverStore);
        this.attachStore(clientDescriptor, reconnectMessage.getClientId());
        LOGGER.info("Client '{}' successfully reconnected to newly promoted ACTIVE after failover.", (Object)clientDescriptor);
        this.management.clientReconnected(clientDescriptor, (ClusterTierClientState)this.connectedClients.get(clientDescriptor));
    }

    private void clearClientTrackedAtReconnectComplete() {
        ClientMessageTracker clientMessageTracker;
        if (!this.reconnectComplete.get() && this.reconnectComplete.compareAndSet(false, true) && (clientMessageTracker = this.stateService.getClientMessageTracker(this.storeIdentifier)) != null) {
            clientMessageTracker.reconcileTrackedClients(this.getTrackedClients().collect(Collectors.toSet()));
        }
    }

    private Stream<UUID> getTrackedClients() {
        return this.connectedClients.entrySet().stream().filter(entry -> ((ClusterTierClientState)entry.getValue()).isAttached()).map(entry -> ((ClusterTierClientState)entry.getValue()).getClientIdentifier());
    }

    private void addInflightInvalidationsForStrongCache(ClientDescriptor clientDescriptor, ClusterTierReconnectMessage reconnectMessage, ServerSideServerStore serverStore) {
        if (serverStore.getStoreConfiguration().getConsistency().equals((Object)Consistency.STRONG)) {
            Set invalidationsInProgress = reconnectMessage.getInvalidationsInProgress();
            LOGGER.debug("Number of Inflight Invalidations from client ID {} for cache {} is {}.", new Object[]{reconnectMessage.getClientId(), this.storeIdentifier, invalidationsInProgress.size()});
            this.inflightInvalidations.add(new InvalidationTuple(clientDescriptor, invalidationsInProgress, reconnectMessage.isClearInProgress()));
        }
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<EhcacheEntityMessage> syncChannel, int concurrencyKey) {
        LOGGER.info("Sync started for concurrency key {}.", (Object)concurrencyKey);
        if (concurrencyKey == 1) {
            this.stateService.getStateRepositoryManager().syncMessageFor(this.storeIdentifier).forEach(arg_0 -> syncChannel.synchronizeToPassive(arg_0));
        } else {
            int segmentId = concurrencyKey - 1 - 1;
            Long dataSizeThreshold = Long.getLong(SYNC_DATA_SIZE_PROP, 0x400000L);
            AtomicLong size = new AtomicLong(0L);
            ServerSideServerStore store = this.stateService.getStore(this.storeIdentifier);
            AtomicReference mappingsToSend = new AtomicReference(new HashMap());
            store.getSegmentKeySets().get(segmentId).forEach(key -> {
                Chain chain;
                try {
                    chain = store.get((long)key);
                }
                catch (TimeoutException e) {
                    throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                }
                for (Element element : chain) {
                    size.addAndGet(element.getPayload().remaining());
                }
                ((Map)mappingsToSend.get()).put(key, chain);
                if (size.get() > dataSizeThreshold) {
                    syncChannel.synchronizeToPassive((EntityMessage)new EhcacheDataSyncMessage((Map)mappingsToSend.get()));
                    mappingsToSend.set(new HashMap());
                    size.set(0L);
                }
            });
            if (!((Map)mappingsToSend.get()).isEmpty()) {
                syncChannel.synchronizeToPassive((EntityMessage)new EhcacheDataSyncMessage(mappingsToSend.get()));
                mappingsToSend.set(new HashMap());
                size.set(0L);
            }
        }
        LOGGER.info("Sync complete for concurrency key {}.", (Object)concurrencyKey);
    }

    public void destroy() {
        LOGGER.info("Destroying cluster tier '{}'", (Object)this.storeIdentifier);
        try {
            this.stateService.destroyServerStore(this.storeIdentifier);
        }
        catch (ClusterException e) {
            LOGGER.error("Failed to destroy server store - does not exist", (Throwable)e);
        }
    }

    Set<ClientDescriptor> getConnectedClients() {
        return Collections.unmodifiableSet(this.connectedClients.keySet());
    }

    Set<ClientDescriptor> getAttachedClients() {
        return Collections.unmodifiableSet(this.connectedClients.entrySet().stream().filter(entry -> ((ClusterTierClientState)entry.getValue()).isAttached()).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    ConcurrentMap<Integer, InvalidationHolder> getClientsWaitingForInvalidation() {
        return this.clientsWaitingForInvalidation;
    }

    private boolean isStrong() {
        return this.configuration.getConsistency() == Consistency.STRONG;
    }

    private static class InvalidationTuple {
        private final ClientDescriptor clientDescriptor;
        private final Set<Long> invalidationsInProgress;
        private final boolean isClearInProgress;

        InvalidationTuple(ClientDescriptor clientDescriptor, Set<Long> invalidationsInProgress, boolean isClearInProgress) {
            this.clientDescriptor = clientDescriptor;
            this.invalidationsInProgress = invalidationsInProgress;
            this.isClearInProgress = isClearInProgress;
        }

        ClientDescriptor getClientDescriptor() {
            return this.clientDescriptor;
        }

        Set<Long> getInvalidationsInProgress() {
            return this.invalidationsInProgress;
        }

        boolean isClearInProgress() {
            return this.isClearInProgress;
        }
    }

    static class InvalidationHolder {
        final ClientDescriptor clientDescriptorWaitingForInvalidation;
        final Set<ClientDescriptor> clientsHavingToInvalidate;
        final Long key;

        InvalidationHolder(ClientDescriptor clientDescriptorWaitingForInvalidation, Set<ClientDescriptor> clientsHavingToInvalidate, Long key) {
            this.clientDescriptorWaitingForInvalidation = clientDescriptorWaitingForInvalidation;
            this.clientsHavingToInvalidate = clientsHavingToInvalidate;
            this.key = key;
        }

        InvalidationHolder(ClientDescriptor clientDescriptorWaitingForInvalidation, Set<ClientDescriptor> clientsHavingToInvalidate) {
            this(clientDescriptorWaitingForInvalidation, clientsHavingToInvalidate, null);
        }
    }
}

