/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.LifecycleException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.internal.messages.EhcacheDataSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.server.management.ClusterTierManagement;
import org.ehcache.clustered.server.state.ClientMessageTracker;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.config.EhcacheStoreStateServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceRegistry;

public class ClusterTierPassiveEntity
implements PassiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierPassiveEntity.class);
    private final EhcacheStateService stateService;
    private final String storeIdentifier;
    private final ClusterTierManagement management;
    private final ServerStoreConfiguration configuration;

    public ClusterTierPassiveEntity(ServiceRegistry registry, ClusterTierEntityConfiguration config, KeySegmentMapper defaultMapper) throws ConfigurationException {
        if (config == null) {
            throw new ConfigurationException("ClusterTierManagerConfiguration cannot be null");
        }
        this.storeIdentifier = config.getStoreIdentifier();
        this.configuration = config.getConfiguration();
        this.stateService = (EhcacheStateService)registry.getService((ServiceConfiguration)new EhcacheStoreStateServiceConfig(config.getManagerIdentifier(), defaultMapper));
        if (this.stateService == null) {
            throw new AssertionError((Object)"Server failed to retrieve EhcacheStateService.");
        }
        this.management = new ClusterTierManagement(registry, this.stateService, false, this.storeIdentifier, config.getManagerIdentifier());
    }

    public void createNew() throws ConfigurationException {
        this.stateService.createStore(this.storeIdentifier, this.configuration, false);
        this.management.init();
    }

    private boolean isEventual() {
        return this.configuration.getConsistency() == Consistency.EVENTUAL;
    }

    public void invoke(EhcacheEntityMessage message) {
        block13: {
            try {
                if (message instanceof EhcacheOperationMessage) {
                    EhcacheOperationMessage operationMessage = (EhcacheOperationMessage)message;
                    EhcacheMessageType messageType = operationMessage.getMessageType();
                    if (EhcacheMessageType.isStoreOperationMessage((EhcacheMessageType)messageType)) {
                        try {
                            this.invokeServerStoreOperation((ServerStoreOpMessage)message);
                        }
                        catch (ClusterException e) {
                            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
                        }
                        break block13;
                    }
                    if (EhcacheMessageType.isStateRepoOperationMessage((EhcacheMessageType)messageType)) {
                        try {
                            this.stateService.getStateRepositoryManager().invoke((StateRepositoryOpMessage)message);
                            this.applyMessage(operationMessage);
                        }
                        catch (ClusterException e) {
                            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
                        }
                        break block13;
                    }
                    if (EhcacheMessageType.isPassiveReplicationMessage((EhcacheMessageType)messageType)) {
                        try {
                            this.invokeRetirementMessages((PassiveReplicationMessage)message);
                        }
                        catch (ClusterException e) {
                            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
                        }
                        break block13;
                    }
                    throw new AssertionError((Object)("Unsupported EhcacheOperationMessage: " + operationMessage.getMessageType()));
                }
                if (message instanceof EhcacheSyncMessage) {
                    this.invokeSyncOperation((EhcacheSyncMessage)message);
                    break block13;
                }
                throw new AssertionError((Object)("Unsupported EhcacheEntityMessage: " + message.getClass()));
            }
            catch (ClusterException e) {
                throw new IllegalStateException("A lifecycle or sync operation failed", e);
            }
        }
    }

    private void invokeSyncOperation(EhcacheSyncMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case DATA: {
                EhcacheDataSyncMessage dataSyncMessage = (EhcacheDataSyncMessage)message;
                ServerSideServerStore store = this.stateService.getStore(this.storeIdentifier);
                dataSyncMessage.getChainMap().entrySet().forEach(entry -> store.put((Long)entry.getKey(), (Chain)entry.getValue()));
                break;
            }
            case STATE_REPO: {
                EhcacheStateRepoSyncMessage stateRepoSyncMessage = (EhcacheStateRepoSyncMessage)message;
                this.stateService.getStateRepositoryManager().processSyncMessage(stateRepoSyncMessage);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Sync operation " + (Object)((Object)message.getMessageType())));
            }
        }
    }

    private void invokeRetirementMessages(PassiveReplicationMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case CHAIN_REPLICATION_OP: {
                LOGGER.debug("Chain Replication message for msgId {} & client Id {}", (Object)message.getId(), (Object)message.getClientId());
                PassiveReplicationMessage.ChainReplicationMessage retirementMessage = (PassiveReplicationMessage.ChainReplicationMessage)message;
                ServerSideServerStore cacheStore = this.stateService.getStore(this.storeIdentifier);
                if (cacheStore == null) {
                    throw new LifecycleException("cluster tier does not exist : '" + this.storeIdentifier + "'");
                }
                this.applyMessage(message);
                if (this.isEventual()) {
                    this.stateService.getInvalidationTracker(this.storeIdentifier).trackHashInvalidation(retirementMessage.getKey());
                }
                cacheStore.put(retirementMessage.getKey(), retirementMessage.getChain());
                break;
            }
            case INVALIDATION_COMPLETE: {
                if (!this.isEventual()) break;
                PassiveReplicationMessage.InvalidationCompleteMessage invalidationCompleteMessage = (PassiveReplicationMessage.InvalidationCompleteMessage)message;
                this.stateService.getInvalidationTracker(this.storeIdentifier).untrackHashInvalidation(invalidationCompleteMessage.getKey());
                break;
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                if (!this.isEventual()) break;
                this.stateService.getInvalidationTracker(this.storeIdentifier).setClearInProgress(false);
                break;
            }
            case CLIENT_ID_TRACK_OP: {
                this.stateService.getClientMessageTracker(this.storeIdentifier).remove(message.getClientId());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Retirement Message : " + (Object)((Object)message)));
            }
        }
    }

    private void invokeServerStoreOperation(ServerStoreOpMessage message) throws ClusterException {
        ServerSideServerStore cacheStore = this.stateService.getStore(this.storeIdentifier);
        if (cacheStore == null) {
            throw new LifecycleException("cluster tier does not exist : '" + this.storeIdentifier + "'");
        }
        switch (message.getMessageType()) {
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                cacheStore.replaceAtHead(replaceAtHeadMessage.getKey(), replaceAtHeadMessage.getExpect(), replaceAtHeadMessage.getUpdate());
                break;
            }
            case CLEAR: {
                LOGGER.info("Clearing cluster tier {}", (Object)this.storeIdentifier);
                try {
                    cacheStore.clear();
                }
                catch (TimeoutException e) {
                    throw new AssertionError((Object)"Server side store is not expected to throw timeout exception");
                }
                if (!this.isEventual()) break;
                this.stateService.getInvalidationTracker(this.storeIdentifier).setClearInProgress(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported ServerStore operation : " + message.getMessageType()));
            }
        }
    }

    private void applyMessage(EhcacheOperationMessage message) {
        ClientMessageTracker clientMessageTracker = this.stateService.getClientMessageTracker(this.storeIdentifier);
        clientMessageTracker.applied(message.getId(), message.getClientId());
    }

    public void startSyncEntity() {
        LOGGER.info("Sync started.");
    }

    public void endSyncEntity() {
        LOGGER.info("Sync completed.");
    }

    public void startSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync started for concurrency key {}.", (Object)concurrencyKey);
    }

    public void endSyncConcurrencyKey(int concurrencyKey) {
        LOGGER.info("Sync complete for concurrency key {}.", (Object)concurrencyKey);
    }

    public void destroy() {
        LOGGER.info("Destroying cluster tier '{}'", (Object)this.storeIdentifier);
        try {
            this.stateService.destroyServerStore(this.storeIdentifier);
        }
        catch (ClusterException e) {
            throw new AssertionError((Object)e);
        }
    }
}

