/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.terracotta.management.model.cluster.Node;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public abstract class AbstractNode<P extends Contextual>
implements Node {
    private static final long serialVersionUID = 1L;
    private P parent;
    private final String id;

    public AbstractNode(String id) {
        this.id = Objects.requireNonNull(id);
    }

    final void detach() {
        this.parent = null;
    }

    final void setParent(P parent) {
        this.parent = parent;
    }

    final P getParent() {
        return this.parent;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.getId());
        return map;
    }

    @Override
    public void setContext(Context context) {
    }

    @Override
    public Context getContext() {
        return (this.parent == null ? Context.empty() : this.parent.getContext()).with(this.getContextKey(), this.getId());
    }

    abstract String getContextKey();

    @Override
    public final List<? extends Node> getNodePath() {
        if (this.parent == null || !(this.parent instanceof Node)) {
            return Collections.singletonList(this);
        }
        List<? extends Node> parentNodes = ((Node)this.parent).getNodePath();
        ArrayList<? extends Node> path = new ArrayList<Node>(parentNodes.size() + 1);
        path.addAll(parentNodes);
        path.add(this);
        return path;
    }

    @Override
    public final String getStringPath() {
        List<Node> nodes = this.getNodePath();
        if (nodes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(nodes.get(0).getId());
        for (int i = 1; i < nodes.size(); ++i) {
            sb.append("/").append(nodes.get(i));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNode that = (AbstractNode)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

