/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.management.model.cluster.AbstractNode;
import org.terracotta.management.model.cluster.ClientIdentifier;
import org.terracotta.management.model.cluster.Cluster;
import org.terracotta.management.model.cluster.Connection;
import org.terracotta.management.model.cluster.Endpoint;
import org.terracotta.management.model.cluster.ManagementRegistry;
import org.terracotta.management.model.cluster.Server;
import org.terracotta.management.model.cluster.ServerEntity;
import org.terracotta.management.model.context.Context;

public final class Client
extends AbstractNode<Cluster> {
    private static final long serialVersionUID = 2L;
    public static final String KEY = "clientId";
    private final Map<String, Connection> connections = new TreeMap<String, Connection>();
    private final ClientIdentifier clientIdentifier;
    private final SortedSet<String> tags = new TreeSet<String>();
    private String hostName;
    private volatile ManagementRegistry managementRegistry;

    private Client(ClientIdentifier clientIdentifier) {
        super(clientIdentifier.getClientId());
        this.clientIdentifier = Objects.requireNonNull(clientIdentifier);
    }

    public Optional<ManagementRegistry> getManagementRegistry() {
        return Optional.ofNullable(this.managementRegistry);
    }

    public Client setManagementRegistry(ManagementRegistry managementRegistry) {
        this.managementRegistry = managementRegistry;
        return this;
    }

    public boolean isManageable() {
        return this.managementRegistry != null;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public Client addTag(String tag) {
        return this.addTags(tag);
    }

    public Client addTags(String ... tags) {
        Collections.addAll(this.tags, tags);
        return this;
    }

    public Client setTags(String[] tags) {
        this.tags.clear();
        Collections.addAll(this.tags, tags);
        return this;
    }

    public boolean isTagged(String tag) {
        return this.tags.contains(tag);
    }

    public ClientIdentifier getClientIdentifier() {
        return this.clientIdentifier;
    }

    public String getHostAddress() {
        return this.clientIdentifier.getHostAddress();
    }

    public String getHostName() {
        return this.hostName;
    }

    public Client setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public Cluster getCluster() {
        return (Cluster)this.getParent();
    }

    public long getPid() {
        return this.clientIdentifier.getPid();
    }

    public String getClientId() {
        return this.clientIdentifier.getClientId();
    }

    public String getVmId() {
        return this.clientIdentifier.getVmId();
    }

    public String getLogicalConnectionUid() {
        return this.clientIdentifier.getConnectionUid();
    }

    public String getName() {
        return this.clientIdentifier.getName();
    }

    public Map<String, Connection> getConnections() {
        return this.connections;
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public Client addConnection(Connection connection) {
        for (Connection c : this.connections.values()) {
            if (c.getClientEndpoint().equals(connection.getClientEndpoint())) {
                throw new IllegalArgumentException("Duplicate connection: " + connection.getId() + ": same endpoint: " + c.getClientEndpoint());
            }
            if (this.getLogicalConnectionUid().equals(connection.getLogicalConnectionUid())) continue;
            throw new IllegalArgumentException("Connection " + connection + " does not belong to client " + this);
        }
        if (this.connections.putIfAbsent(connection.getId(), connection) != null) {
            throw new IllegalArgumentException("Duplicate connection: " + connection.getId());
        }
        connection.setParent(this);
        return this;
    }

    public Optional<Connection> getConnection(Context context) {
        return this.getConnection(context.get("connectionId"));
    }

    public Optional<Connection> getConnection(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.connections.get(id));
    }

    public Stream<Connection> connectionStream() {
        return this.connections.values().stream();
    }

    public Stream<Connection> connectionStream(Server server) {
        return this.connectionStream().filter(c -> c.isConnectedTo(server));
    }

    public Optional<Connection> getConnection(Server server, Endpoint endpoint) {
        return this.connectionStream().filter(c -> c.isConnectedTo(server) && c.isConnectedTo(endpoint)).findFirst();
    }

    public Optional<Connection> removeConnection(String id) {
        Optional<Connection> connection = this.getConnection(id);
        connection.ifPresent(c -> {
            if (this.connections.remove(id, c)) {
                c.detach();
            }
        });
        return connection;
    }

    public Stream<ServerEntity> fetchedServerEntityStream() {
        return this.connectionStream().flatMap(Connection::fetchedServerEntityStream);
    }

    public int getFetchedServerEntityCount() {
        return this.connectionStream().mapToInt(Connection::getFetchedServerEntityCount).sum();
    }

    @Override
    public void remove() {
        Cluster parent = (Cluster)this.getParent();
        if (parent != null) {
            parent.removeClient(this.getId());
        }
    }

    public boolean isConnectedTo(Server server) {
        return this.connectionStream(server).findFirst().isPresent();
    }

    public boolean isConnected() {
        return this.connectionStream().filter(Connection::isConnected).findFirst().isPresent();
    }

    public boolean hasFetchedServerEntity(String name, String type) {
        return this.getFetchedServerEntity(name, type).isPresent();
    }

    public Optional<ServerEntity> getFetchedServerEntity(String name, String type) {
        return this.fetchedServerEntityStream().filter(serverEntity -> serverEntity.is(name, type)).findFirst();
    }

    @Override
    String getContextKey() {
        return KEY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Client client = (Client)o;
        if (!this.connections.equals(client.connections)) {
            return false;
        }
        if (!this.clientIdentifier.equals(client.clientIdentifier)) {
            return false;
        }
        if (!this.tags.equals(client.tags)) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(client.hostName) : client.hostName != null) {
            return false;
        }
        return this.managementRegistry != null ? this.managementRegistry.equals(client.managementRegistry) : client.managementRegistry == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.connections.hashCode();
        result = 31 * result + this.clientIdentifier.hashCode();
        result = 31 * result + this.tags.hashCode();
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.managementRegistry != null ? this.managementRegistry.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("pid", this.getPid());
        map.put("hostAddress", this.getHostAddress());
        map.put("name", this.getName());
        map.put("logicalConnectionUid", this.getLogicalConnectionUid());
        map.put("vmId", this.getVmId());
        map.put(KEY, this.getClientId());
        map.put("hostName", this.getHostName());
        map.put("tags", this.tags);
        map.put("connections", this.connectionStream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).map(Connection::toMap).collect(Collectors.toList()));
        map.put("managementRegistry", this.managementRegistry == null ? null : this.managementRegistry.toMap());
        return map;
    }

    public static Client create(String clientIdentifier) {
        return Client.create(ClientIdentifier.valueOf(clientIdentifier));
    }

    public static Client create(ClientIdentifier clientIdentifier) {
        return new Client(clientIdentifier);
    }
}

