/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.management.model.cluster.Client;
import org.terracotta.management.model.cluster.ClientIdentifier;
import org.terracotta.management.model.cluster.Node;
import org.terracotta.management.model.cluster.Server;
import org.terracotta.management.model.cluster.ServerEntity;
import org.terracotta.management.model.cluster.Stripe;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public final class Cluster
implements Contextual {
    private static final long serialVersionUID = 2L;
    private final Map<String, Client> clients = new TreeMap<String, Client>();
    private final Map<String, Stripe> stripes = new TreeMap<String, Stripe>();

    private Cluster() {
    }

    public Stream<Client> clientStream() {
        return this.clients.values().stream();
    }

    public Stream<Stripe> stripeStream() {
        return this.stripes.values().stream();
    }

    public Map<String, Client> getClients() {
        return this.clients;
    }

    public int getClientCount() {
        return this.clients.size();
    }

    public Map<String, Stripe> getStripes() {
        return this.stripes;
    }

    public int getStripeCount() {
        return this.stripes.size();
    }

    public Stripe getSingleStripe() throws NoSuchElementException {
        if (this.getStripeCount() != 1) {
            throw new NoSuchElementException();
        }
        return this.stripeStream().findFirst().get();
    }

    public Cluster addClient(Client client) {
        for (Client c : this.clients.values()) {
            if (!c.getClientIdentifier().equals(client.getClientIdentifier())) continue;
            throw new IllegalArgumentException("Duplicate client: " + client.getClientIdentifier());
        }
        if (this.clients.putIfAbsent(client.getId(), client) != null) {
            throw new IllegalArgumentException("Duplicate client: " + client.getId());
        }
        client.setParent(this);
        return this;
    }

    public Optional<Client> getClient(Context context) {
        return this.getClient(context.get("clientId"));
    }

    public Optional<Client> getClient(ClientIdentifier clientIdentifier) {
        return this.clientStream().filter(client -> client.getClientIdentifier().equals(clientIdentifier)).findFirst();
    }

    public Optional<Client> getClient(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.clients.get(id));
    }

    public Optional<Client> removeClient(String id) {
        Optional<Client> client = this.getClient(id);
        client.ifPresent(c -> {
            if (this.clients.remove(id, c)) {
                c.detach();
            }
        });
        return client;
    }

    public Cluster addStripe(Stripe stripe) {
        if (this.stripes.putIfAbsent(stripe.getId(), stripe) != null) {
            throw new IllegalArgumentException("Duplicate stripe: " + stripe.getId());
        }
        stripe.setParent(this);
        return this;
    }

    public Optional<Stripe> getStripe(Context context) {
        return this.getStripe(context.get("stripeId"));
    }

    public Optional<Stripe> getStripe(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.stripes.get(id));
    }

    public Optional<Stripe> removeStripe(String id) {
        Optional<Stripe> stripe = this.getStripe(id);
        stripe.ifPresent(s -> {
            if (this.stripes.remove(id, s)) {
                s.detach();
            }
        });
        return stripe;
    }

    public Optional<ServerEntity> getActiveServerEntity(Context context) {
        return this.getStripe(context).flatMap(s -> s.getActiveServerEntity(context));
    }

    public Optional<ServerEntity> getServerEntity(Context context) {
        return this.getStripe(context).flatMap(s -> s.getServerEntity(context));
    }

    public Optional<Server> getServer(Context context) {
        return this.getStripe(context).flatMap(s -> s.getServer(context));
    }

    public List<? extends Node> getNodes(Context context) {
        LinkedList nodes = new LinkedList();
        this.getStripe(context).ifPresent(stripe1 -> {
            nodes.add(stripe1);
            stripe1.getServer(context).ifPresent(server -> {
                nodes.add(server);
                server.getServerEntity(context).ifPresent(nodes::add);
            });
        });
        this.getClient(context).ifPresent(nodes::add);
        return nodes;
    }

    public String getPath(Context context) {
        List<? extends Node> nodes = this.getNodes(context);
        StringBuilder sb = new StringBuilder(nodes.isEmpty() ? "" : nodes.get(0).getId());
        for (int i = 1; i < nodes.size(); ++i) {
            sb.append("/").append(nodes.get(i));
        }
        return sb.toString();
    }

    public Stream<ServerEntity> serverEntityStream() {
        return this.stripeStream().flatMap(Stripe::serverEntityStream);
    }

    public Stream<ServerEntity> activeServerEntityStream() {
        return this.stripeStream().flatMap(Stripe::activeServerEntityStream);
    }

    public Stream<Server> serverStream() {
        return this.stripeStream().flatMap(Stripe::serverStream);
    }

    @Override
    public Context getContext() {
        return Context.empty();
    }

    @Override
    public void setContext(Context context) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        if (!this.clients.equals(cluster.clients)) {
            return false;
        }
        return this.stripes.equals(cluster.stripes);
    }

    public int hashCode() {
        int result = this.clients.hashCode();
        result = 31 * result + this.stripes.hashCode();
        return result;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("stripes", this.stripeStream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).map(Stripe::toMap).collect(Collectors.toList()));
        map.put("clients", this.clientStream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).map(Client::toMap).collect(Collectors.toList()));
        return map;
    }

    public static Cluster create() {
        return new Cluster();
    }
}

