/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.terracotta.management.model.cluster.AbstractNode;
import org.terracotta.management.model.cluster.Client;
import org.terracotta.management.model.cluster.Endpoint;
import org.terracotta.management.model.cluster.Server;
import org.terracotta.management.model.cluster.ServerEntity;
import org.terracotta.management.model.cluster.ServerEntityIdentifier;

public final class Connection
extends AbstractNode<Client> {
    private static final long serialVersionUID = 3L;
    public static final String KEY = "connectionId";
    private final Map<String, Long> serverEntityIds = new TreeMap<String, Long>();
    private final Endpoint clientEndpoint;
    private final String stripeId;
    private final String serverId;
    private final String logicalConnectionUid;

    private Connection(String id, String logicalConnectionUid, Server server, Endpoint clientEndpoint) {
        super(id);
        this.logicalConnectionUid = Objects.requireNonNull(logicalConnectionUid);
        this.clientEndpoint = Objects.requireNonNull(clientEndpoint);
        this.serverId = server.getId();
        this.stripeId = server.getStripe().getId();
    }

    public String getLogicalConnectionUid() {
        return this.logicalConnectionUid;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getStripeId() {
        return this.stripeId;
    }

    public Endpoint getClientEndpoint() {
        return this.clientEndpoint;
    }

    public Client getClient() {
        return (Client)this.getParent();
    }

    public Optional<Server> getServer() {
        try {
            return this.getClient().getCluster().getStripe(this.stripeId).flatMap(stripe -> stripe.getServer(this.serverId));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Stream<ServerEntity> fetchedServerEntityStream() {
        return this.getServer().map(server -> this.serverEntityIds.keySet().stream().map(server::getServerEntity).filter(Optional::isPresent).map(Optional::get)).orElse(Stream.empty());
    }

    public int getFetchedServerEntityCount() {
        return this.getServer().map(server -> this.serverEntityIds.keySet().stream().map(server::getServerEntity).filter(Optional::isPresent).count()).orElse(0L).intValue();
    }

    @Override
    public void remove() {
        Client parent = (Client)this.getParent();
        if (parent != null) {
            parent.removeConnection(this.getId());
        }
    }

    @Override
    String getContextKey() {
        return KEY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (!this.serverEntityIds.equals(that.serverEntityIds)) {
            return false;
        }
        if (!this.clientEndpoint.equals(that.clientEndpoint)) {
            return false;
        }
        if (this.stripeId != null ? !this.stripeId.equals(that.stripeId) : that.stripeId != null) {
            return false;
        }
        return this.serverId != null ? this.serverId.equals(that.serverId) : that.serverId == null;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.serverEntityIds.hashCode();
        result = 31 * result + this.clientEndpoint.hashCode();
        result = 31 * result + (this.stripeId != null ? this.stripeId.hashCode() : 0);
        result = 31 * result + (this.serverId != null ? this.serverId.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("logicalConnectionUid", this.logicalConnectionUid);
        map.put("clientEndpoint", this.clientEndpoint.toMap());
        map.put("stripeId", this.stripeId);
        map.put("serverId", this.serverId);
        map.put("serverEntityIds", this.serverEntityIds);
        return map;
    }

    public boolean unfetchServerEntity(String name, String type) {
        return this.unfetchServerEntity(ServerEntityIdentifier.create(name, type));
    }

    public boolean unfetchServerEntity(ServerEntityIdentifier serverEntityIdentifier) {
        String id = serverEntityIdentifier.getId();
        Long count = this.serverEntityIds.get(id);
        if (count == null) {
            return false;
        }
        if (count <= 0L) {
            this.serverEntityIds.remove(id);
            return false;
        }
        if (count <= 1L) {
            this.serverEntityIds.remove(id);
            return true;
        }
        this.serverEntityIds.put(id, count - 1L);
        return true;
    }

    public boolean fetchServerEntity(String name, String type) {
        return this.fetchServerEntity(ServerEntityIdentifier.create(name, type));
    }

    public boolean fetchServerEntity(ServerEntityIdentifier serverEntityIdentifier) {
        String id;
        Long count = this.serverEntityIds.get(id = serverEntityIdentifier.getId());
        this.serverEntityIds.put(id, count == null || count <= 0L ? 1L : count + 1L);
        return true;
    }

    public boolean hasFetchedServerEntity(String name, String type) {
        return this.hasFetchedServerEntity(ServerEntityIdentifier.create(name, type));
    }

    public boolean hasFetchedServerEntity(ServerEntityIdentifier serverEntityIdentifier) {
        return this.fetchedServerEntityStream().anyMatch(serverEntity -> serverEntity.is(serverEntityIdentifier));
    }

    public boolean isConnectedTo(Server server) {
        return server.getId().equals(this.serverId) && server.getStripe().getId().equals(this.stripeId);
    }

    public boolean isConnectedTo(Endpoint clientEndpoint) {
        return this.clientEndpoint.equals(clientEndpoint);
    }

    public boolean isConnected() {
        return this.getServer().isPresent();
    }

    public static Connection create(String logicalConnectionUid, Server server, Endpoint clientEndpoint) {
        Objects.requireNonNull(logicalConnectionUid);
        Objects.requireNonNull(server);
        Objects.requireNonNull(clientEndpoint);
        return new Connection(Connection.key(logicalConnectionUid, server, clientEndpoint), logicalConnectionUid, server, clientEndpoint);
    }

    public static String key(String logicalConnectionUid, Server server, Endpoint clientEndpoint) {
        return logicalConnectionUid + ":" + server.getStripe().getName() + ":" + server.getServerName() + ":" + clientEndpoint.getAddress() + ":" + clientEndpoint.getPort();
    }
}

