/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class Endpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String address;
    private final int port;

    private Endpoint(String address, int port) {
        this.address = Objects.requireNonNull(address);
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.port == endpoint.port && this.address.equals(endpoint.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> endpoint = new LinkedHashMap<String, Object>();
        endpoint.put("address", this.address);
        endpoint.put("port", this.port);
        return endpoint;
    }

    public static Endpoint create(String address, int port) {
        return new Endpoint(address, port);
    }

    public static Endpoint valueOf(String str) {
        String[] parts = str.split(":");
        return Endpoint.create(parts[0], Integer.parseInt(parts[1]));
    }
}

