/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.context.CapabilityContext;
import org.terracotta.management.model.capabilities.descriptors.CallDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.Settings;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.context.ContextContainer;

public final class ManagementRegistry
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final ContextContainer contextContainer;
    private final Collection<Capability> capabilities = new ArrayList<Capability>();

    private ManagementRegistry(ContextContainer contextContainer) {
        this.contextContainer = Objects.requireNonNull(contextContainer);
    }

    public ManagementRegistry setCapabilities(Collection<Capability> capabilities) {
        this.capabilities.clear();
        capabilities.forEach(this::addCapability);
        return this;
    }

    public ManagementRegistry setCapabilities(Capability ... capabilities) {
        return this.setCapabilities(Arrays.asList(capabilities));
    }

    public ManagementRegistry addCapability(Capability capability) {
        this.capabilities.add(capability);
        return this;
    }

    public ManagementRegistry addCapabilities(Capability ... capabilities) {
        for (Capability capability : capabilities) {
            this.addCapability(capability);
        }
        return this;
    }

    public Collection<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Optional<Capability> getCapability(String capabilityName) {
        return this.capabilities.stream().filter(capability -> capability.getName().equals(capabilityName)).findFirst();
    }

    public ContextContainer getContextContainer() {
        return this.contextContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementRegistry that = (ManagementRegistry)o;
        if (!this.contextContainer.equals(that.contextContainer)) {
            return false;
        }
        return this.capabilities.equals(that.capabilities);
    }

    public int hashCode() {
        int result = this.contextContainer.hashCode();
        result = 31 * result + this.capabilities.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManagementRegistry{");
        sb.append("contextContainer=").append(this.contextContainer);
        sb.append(", capabilities=").append(this.capabilities.size());
        sb.append('}');
        return sb.toString();
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("contextContainer", ManagementRegistry.toMap(this.contextContainer));
        map.put("capabilities", this.capabilities.stream().map(ManagementRegistry::toMap).collect(Collectors.toList()));
        return map;
    }

    private static Map<String, Object> toMap(Capability capability) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", capability.getName());
        map.put("context", capability.getCapabilityContext().getAttributes().stream().map(ManagementRegistry::toMap).collect(Collectors.toList()));
        ArrayList<Map<String, Object>> descriptorList = new ArrayList<Map<String, Object>>(capability.getDescriptors().size());
        map.put("descriptors", descriptorList);
        for (Descriptor descriptor : capability.getDescriptors()) {
            if (descriptor instanceof CallDescriptor) {
                descriptorList.add(ManagementRegistry.toMap((CallDescriptor)descriptor));
                continue;
            }
            if (descriptor instanceof StatisticDescriptor) {
                descriptorList.add(ManagementRegistry.toMap((StatisticDescriptor)descriptor));
                continue;
            }
            if (descriptor instanceof Settings) {
                descriptorList.add(ManagementRegistry.toMap((Settings)descriptor));
                continue;
            }
            descriptorList.add(ManagementRegistry.toMap(descriptor));
        }
        return map;
    }

    private static Map<String, Object> toMap(CapabilityContext.Attribute attribute) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", attribute.getName());
        map.put("required", attribute.isRequired());
        return map;
    }

    private static Map<String, Object> toMap(StatisticDescriptor descriptor) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", descriptor.getName());
        map.put("type", descriptor.getType());
        return map;
    }

    private static Map<String, Object> toMap(CallDescriptor descriptor) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", descriptor.getName());
        map.put("returnType", descriptor.getReturnType());
        map.put("parameters", descriptor.getParameters().stream().map(ManagementRegistry::toMap).collect(Collectors.toList()));
        return map;
    }

    private static Map<String, Object> toMap(Settings descriptor) {
        return descriptor;
    }

    private static Map<String, Object> toMap(Descriptor descriptor) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", descriptor.getClass().getName());
        return map;
    }

    private static Map<String, Object> toMap(CallDescriptor.Parameter parameter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", parameter.getName());
        map.put("type", parameter.getType());
        return map;
    }

    private static Map<String, Object> toMap(ContextContainer contextContainer) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(contextContainer.getName(), contextContainer.getValue());
        map.put("subContexts", contextContainer.getSubContexts().stream().map(ManagementRegistry::toMap).collect(Collectors.toList()));
        return map;
    }

    public static ManagementRegistry create(ContextContainer contextContainer) {
        return new ManagementRegistry(contextContainer);
    }
}

