/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.management.model.cluster.AbstractNode;
import org.terracotta.management.model.cluster.ServerEntity;
import org.terracotta.management.model.cluster.ServerEntityIdentifier;
import org.terracotta.management.model.cluster.Stripe;
import org.terracotta.management.model.context.Context;

public final class Server
extends AbstractNode<Stripe> {
    private static final long serialVersionUID = 2L;
    public static final String KEY = "serverId";
    public static final String NAME_KEY = "serverName";
    private final Map<String, ServerEntity> serverEntities = new TreeMap<String, ServerEntity>();
    private final String serverName;
    private String hostName;
    private String hostAddress;
    private String bindAddress;
    private int bindPort;
    private int groupPort;
    private State state = State.UNKNOWN;
    private String version;
    private String buildId;
    private long startTime;
    private long upTimeSec;
    private long activateTime;

    private Server(String serverId, String serverName) {
        super(serverId);
        this.serverName = Objects.requireNonNull(serverName);
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Stripe getStripe() {
        return (Stripe)this.getParent();
    }

    @Override
    String getContextKey() {
        return KEY;
    }

    @Override
    public Context getContext() {
        return super.getContext().with(NAME_KEY, this.getServerName());
    }

    public String getBuildId() {
        return this.buildId;
    }

    public Server setBuildId(String buildId) {
        this.buildId = buildId;
        return this;
    }

    public State getState() {
        return this.state;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Server setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public Server setBindPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public Server setGroupPort(int groupPort) {
        this.groupPort = groupPort;
        return this;
    }

    public Server setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Server setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Server setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getUpTimeSec() {
        return this.upTimeSec;
    }

    public Server setUpTimeSec(long upTimeSec) {
        this.upTimeSec = upTimeSec;
        return this;
    }

    public Server computeUpTime() {
        return this.computeUpTime(Clock.systemUTC());
    }

    public Server computeUpTime(Clock clock) {
        this.upTimeSec = this.startTime > 0L ? (clock.millis() - this.startTime) / 1000L : 0L;
        return this;
    }

    public Server setState(State state) {
        this.state = state;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Server setVersion(String version) {
        this.version = version;
        return this;
    }

    public long getActivateTime() {
        return this.activateTime;
    }

    public Server setActivateTime(long activateTime) {
        this.activateTime = activateTime > 0L ? activateTime : 0L;
        return this;
    }

    public final Map<String, ServerEntity> getServerEntities() {
        return this.serverEntities;
    }

    public final int getServerEntityCount() {
        return this.serverEntities.size();
    }

    public final Stream<ServerEntity> serverEntityStream() {
        return this.serverEntities.values().stream();
    }

    public final Server addServerEntity(ServerEntity serverEntity) {
        for (ServerEntity m : this.serverEntities.values()) {
            if (!m.is(serverEntity.getType(), serverEntity.getName())) continue;
            throw new IllegalArgumentException("Duplicate serverEntity: type=" + serverEntity.getType() + ", name=" + serverEntity.getName());
        }
        if (this.serverEntities.putIfAbsent(serverEntity.getId(), serverEntity) != null) {
            throw new IllegalArgumentException("Duplicate serverEntity: " + serverEntity.getId());
        }
        serverEntity.setParent(this);
        return this;
    }

    public final Optional<ServerEntity> getServerEntity(Context context) {
        String id = context.get("entityId");
        if (id != null) {
            return this.getServerEntity(id);
        }
        String type = context.get("entityType");
        String name = context.get("entityName");
        if (type != null && name != null) {
            return this.getServerEntity(name, type);
        }
        String consumerId = context.get("consumerId");
        if (consumerId != null) {
            long cid = Long.parseLong(consumerId);
            return this.serverEntityStream().filter(serverEntity -> serverEntity.getConsumerId() == cid).findFirst();
        }
        return Optional.empty();
    }

    public final Optional<ServerEntity> getServerEntity(ServerEntityIdentifier serverEntityIdentifier) {
        return this.getServerEntity(serverEntityIdentifier.getId());
    }

    public final Optional<ServerEntity> getServerEntity(long consumerId) {
        return this.serverEntityStream().filter(serverEntity -> serverEntity.getConsumerId() == consumerId).findFirst();
    }

    public final Optional<ServerEntity> getServerEntity(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.serverEntities.get(id));
    }

    public final Optional<ServerEntity> getServerEntity(String name, String type) {
        return this.serverEntityStream().filter(serverEntity -> serverEntity.is(name, type)).findFirst();
    }

    public final boolean hasServerEntity(String name, String type) {
        return this.getServerEntity(name, type).isPresent();
    }

    public final Optional<ServerEntity> removeServerEntity(String id) {
        Optional<ServerEntity> serverEntity = this.getServerEntity(id);
        serverEntity.ifPresent(m -> {
            if (this.serverEntities.remove(id, m)) {
                m.detach();
            }
        });
        return serverEntity;
    }

    public final Stream<ServerEntity> serverEntityStream(String type) {
        return this.serverEntityStream().filter(serverEntity -> serverEntity.isType(type));
    }

    @Override
    public void remove() {
        Stripe parent = (Stripe)this.getParent();
        if (parent != null) {
            parent.removeServer(this.getId());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Server server = (Server)o;
        if (this.bindPort != server.bindPort) {
            return false;
        }
        if (this.groupPort != server.groupPort) {
            return false;
        }
        if (this.startTime != server.startTime) {
            return false;
        }
        if (this.activateTime != server.activateTime) {
            return false;
        }
        if (!this.serverEntities.equals(server.serverEntities)) {
            return false;
        }
        if (this.serverName != null ? !this.serverName.equals(server.serverName) : server.serverName != null) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(server.hostName) : server.hostName != null) {
            return false;
        }
        if (this.hostAddress != null ? !this.hostAddress.equals(server.hostAddress) : server.hostAddress != null) {
            return false;
        }
        if (this.bindAddress != null ? !this.bindAddress.equals(server.bindAddress) : server.bindAddress != null) {
            return false;
        }
        if (this.state != server.state) {
            return false;
        }
        if (this.version != null ? !this.version.equals(server.version) : server.version != null) {
            return false;
        }
        return this.buildId != null ? this.buildId.equals(server.buildId) : server.buildId == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serverEntities.hashCode();
        result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.hostAddress != null ? this.hostAddress.hashCode() : 0);
        result = 31 * result + (this.bindAddress != null ? this.bindAddress.hashCode() : 0);
        result = 31 * result + this.bindPort;
        result = 31 * result + this.groupPort;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.buildId != null ? this.buildId.hashCode() : 0);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.activateTime ^ this.activateTime >>> 32);
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("serverEntities", this.serverEntityStream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).map(ServerEntity::toMap).collect(Collectors.toList()));
        map.put(NAME_KEY, this.getServerName());
        map.put("hostName", this.hostName);
        map.put("hostAddress", this.hostAddress);
        map.put("bindAddress", this.bindAddress);
        map.put("bindPort", this.bindPort);
        map.put("groupPort", this.groupPort);
        map.put("state", this.state.name());
        map.put("version", this.version);
        map.put("buildId", this.buildId);
        map.put("startTime", this.startTime);
        map.put("upTimeSec", this.upTimeSec);
        map.put("activateTime", this.activateTime);
        return map;
    }

    public static Server create(String serverName) {
        return new Server(serverName, serverName);
    }

    public static enum State {
        UNREACHABLE,
        UNINITIALIZED,
        SYNCHRONIZING,
        PASSIVE,
        ACTIVE,
        UNKNOWN;


        public static State parse(String state) {
            if (state == null) {
                return UNKNOWN;
            }
            for (State serverState : State.values()) {
                if (!serverState.name().equalsIgnoreCase(state)) continue;
                return serverState;
            }
            return UNKNOWN;
        }
    }
}

