/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.Map;
import java.util.Optional;
import org.terracotta.management.model.cluster.AbstractNode;
import org.terracotta.management.model.cluster.ManagementRegistry;
import org.terracotta.management.model.cluster.Server;
import org.terracotta.management.model.cluster.ServerEntityIdentifier;
import org.terracotta.management.model.context.Context;

public final class ServerEntity
extends AbstractNode<Server> {
    private static final long serialVersionUID = 3L;
    public static final String KEY = "entityId";
    public static final String TYPE_KEY = "entityType";
    public static final String NAME_KEY = "entityName";
    public static final String CONSUMER_ID = "consumerId";
    private final ServerEntityIdentifier identifier;
    private volatile ManagementRegistry managementRegistry;
    private long consumerId;

    private ServerEntity(ServerEntityIdentifier identifier) {
        super(identifier.getId());
        this.identifier = identifier;
    }

    public Optional<ManagementRegistry> getManagementRegistry() {
        return Optional.ofNullable(this.managementRegistry);
    }

    public ServerEntity setManagementRegistry(ManagementRegistry managementRegistry) {
        this.managementRegistry = managementRegistry;
        return this;
    }

    public long getConsumerId() {
        return this.consumerId;
    }

    public ServerEntity setConsumerId(long consumerId) {
        this.consumerId = consumerId;
        return this;
    }

    public ServerEntityIdentifier getServerEntityIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.identifier.getType();
    }

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    public boolean isManageable() {
        return this.managementRegistry != null;
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public Context getContext() {
        Context context = super.getContext().with(NAME_KEY, this.getName()).with(TYPE_KEY, this.getType());
        if (this.consumerId > 0L) {
            context = context.with(CONSUMER_ID, String.valueOf(this.consumerId));
        }
        return context;
    }

    @Override
    public void remove() {
        Server parent = (Server)this.getParent();
        if (parent != null) {
            parent.removeServerEntity(this.getId());
        }
    }

    public Server getServer() {
        return (Server)this.getParent();
    }

    @Override
    String getContextKey() {
        return KEY;
    }

    public boolean is(String name, String type) {
        return this.getName().equals(name) && this.getType().equals(type);
    }

    public boolean is(ServerEntityIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerEntity that = (ServerEntity)o;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.managementRegistry != null ? this.managementRegistry.equals(that.managementRegistry) : that.managementRegistry == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + (this.managementRegistry != null ? this.managementRegistry.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("type", this.getType());
        map.put("name", this.getName());
        map.put(CONSUMER_ID, this.getConsumerId());
        map.put("managementRegistry", this.managementRegistry == null ? null : this.managementRegistry.toMap());
        return map;
    }

    public static ServerEntity create(String serverEntityName, String type) {
        return ServerEntity.create(ServerEntityIdentifier.create(serverEntityName, type));
    }

    public static ServerEntity create(ServerEntityIdentifier serverEntityIdentifier) {
        return new ServerEntity(serverEntityIdentifier);
    }
}

