/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.Serializable;
import java.util.Objects;

public class ServerEntityIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;

    private ServerEntityIdentifier(String name, String type) {
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.name + ":" + this.type;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerEntityIdentifier that = (ServerEntityIdentifier)o;
        return this.type.equals(that.type) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public static ServerEntityIdentifier create(String name, String type) {
        return new ServerEntityIdentifier(name, type);
    }
}

