/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.management.model.cluster.AbstractNode;
import org.terracotta.management.model.cluster.Cluster;
import org.terracotta.management.model.cluster.Server;
import org.terracotta.management.model.cluster.ServerEntity;
import org.terracotta.management.model.cluster.ServerEntityIdentifier;
import org.terracotta.management.model.context.Context;

public final class Stripe
extends AbstractNode<Cluster> {
    private static final long serialVersionUID = 2L;
    public static final String KEY = "stripeId";
    private final Map<String, Server> servers = new TreeMap<String, Server>();

    private Stripe(String name) {
        super(name);
    }

    public String getName() {
        return this.getId();
    }

    @Override
    String getContextKey() {
        return KEY;
    }

    public Map<String, Server> getServers() {
        return this.servers;
    }

    public Stream<Server> serverStream() {
        return this.servers.values().stream();
    }

    public Cluster getCluster() {
        return (Cluster)this.getParent();
    }

    public int getServerCount() {
        return this.servers.size();
    }

    public Stripe addServer(Server server) {
        if (this.servers.putIfAbsent(server.getId(), server) != null) {
            throw new IllegalArgumentException("Duplicate server: " + server.getId());
        }
        server.setParent(this);
        return this;
    }

    public Optional<Server> getServer(Context context) {
        String key = context.get("serverId");
        if (key != null) {
            return this.getServer(key);
        }
        String name = context.get("serverName");
        if (name != null) {
            return this.getServerByName(name);
        }
        return Optional.empty();
    }

    public Optional<Server> getServer(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.servers.get(id));
    }

    public Optional<Server> getServerByName(String serverName) {
        return this.serverStream().filter(server -> server.getServerName().equals(serverName)).findFirst();
    }

    public Optional<Server> getActiveServer() {
        return this.serverStream().filter(Server::isActive).findFirst();
    }

    public Optional<Server> removeServerByName(String serverName) {
        Optional<Server> server = this.getServerByName(serverName);
        server.ifPresent(s -> {
            if (this.servers.remove(s.getId(), s)) {
                s.detach();
            }
        });
        return server;
    }

    public Optional<Server> removeServer(String id) {
        Optional<Server> server = this.getServer(id);
        server.ifPresent(s -> {
            if (this.servers.remove(id, s)) {
                s.detach();
            }
        });
        return server;
    }

    public Optional<ServerEntity> getActiveServerEntity(Context context) {
        return this.getActiveServer().flatMap(s -> s.getServerEntity(context));
    }

    public Optional<ServerEntity> getServerEntity(Context context) {
        return this.getServer(context).flatMap(s -> s.getServerEntity(context));
    }

    public Optional<ServerEntity> getActiveServerEntity(ServerEntityIdentifier identifier) {
        return this.getActiveServer().flatMap(s -> s.getServerEntity(identifier));
    }

    public Optional<ServerEntity> getActiveServerEntity(String name, String type) {
        return this.getActiveServer().flatMap(s -> s.getServerEntity(name, type));
    }

    public Stream<ServerEntity> serverEntityStream() {
        return this.serverStream().flatMap(Server::serverEntityStream);
    }

    public Stream<ServerEntity> activeServerEntityStream() {
        return this.getActiveServer().map(Server::serverEntityStream).orElse(Stream.empty());
    }

    @Override
    public void remove() {
        Cluster parent = (Cluster)this.getParent();
        if (parent != null) {
            parent.removeStripe(this.getId());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Stripe stripe = (Stripe)o;
        return this.servers.equals(stripe.servers);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("name", this.getName());
        map.put("servers", this.serverStream().sorted((o1, o2) -> o1.getId().compareTo(o2.getId())).map(Server::toMap).collect(Collectors.toList()));
        return map;
    }

    public static Stripe create(String name) {
        return new Stripe(name);
    }
}

