/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.DefaultCapability;
import org.terracotta.management.model.capabilities.context.CapabilityContext;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.registry.action.ExposedObject;

public abstract class AbstractManagementProvider<T>
implements ManagementProvider<T> {
    protected static final Comparator<StatisticDescriptor> STATISTIC_DESCRIPTOR_COMPARATOR = new Comparator<StatisticDescriptor>(){

        @Override
        public int compare(StatisticDescriptor o1, StatisticDescriptor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Queue<ExposedObject<T>> exposedObjects = new ConcurrentLinkedQueue<ExposedObject<T>>();
    private final String capabilityName;
    private final Class<? extends T> managedType;
    private final CapabilityContext capabilityContext;

    public AbstractManagementProvider(Class<? extends T> managedType) {
        this.managedType = managedType;
        this.capabilityName = this.buildCapabilityName();
        this.capabilityContext = this.buildCapabilityContext();
    }

    @Override
    public Class<? extends T> getManagedType() {
        return this.managedType;
    }

    @Override
    public String getCapabilityName() {
        return this.capabilityName;
    }

    @Override
    public CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    @Override
    public Capability getCapability() {
        return new DefaultCapability(this.getCapabilityName(), this.getCapabilityContext(), this.getDescriptors());
    }

    @Override
    public void register(T managedObject) {
        ExposedObject<T> exposedObject = this.wrap(managedObject);
        this.exposedObjects.add(exposedObject);
    }

    @Override
    public void unregister(T managedObject) {
        for (ExposedObject exposedObject : this.exposedObjects) {
            if (!exposedObject.getTarget().equals(managedObject) || !this.exposedObjects.remove(exposedObject)) continue;
            this.dispose(exposedObject);
            return;
        }
    }

    @Override
    public void close() {
        while (!this.exposedObjects.isEmpty()) {
            this.dispose(this.exposedObjects.poll());
        }
    }

    @Override
    public boolean supports(Context context) {
        return this.findExposedObject((T)context) != null;
    }

    @Override
    public Map<String, Number> collectStatistics(Context context, Collection<String> statisticNames) {
        throw new UnsupportedOperationException("Not a statistics provider : " + this.getCapabilityName());
    }

    @Override
    public void callAction(Context context, String methodName, Parameter ... parameters) throws ExecutionException {
        this.callAction(context, methodName, Object.class, parameters);
    }

    @Override
    public <V> V callAction(Context context, String methodName, Class<V> returnType, Parameter ... parameters) throws ExecutionException {
        throw new UnsupportedOperationException("Not an action provider : " + this.getCapabilityName());
    }

    @Override
    public Collection<? extends Descriptor> getDescriptors() {
        LinkedHashSet<Descriptor> capabilities = new LinkedHashSet<Descriptor>();
        for (ExposedObject exposedObject : this.exposedObjects) {
            capabilities.addAll(exposedObject.getDescriptors());
        }
        return capabilities;
    }

    protected String buildCapabilityName() {
        Named named = this.getClass().getAnnotation(Named.class);
        return named == null ? this.getClass().getSimpleName() : named.value();
    }

    protected CapabilityContext buildCapabilityContext() {
        ArrayList<CapabilityContext.Attribute> attrs = new ArrayList<CapabilityContext.Attribute>();
        RequiredContext requiredContext = this.getManagedType().getAnnotation(RequiredContext.class);
        if (requiredContext == null) {
            requiredContext = this.getClass().getAnnotation(RequiredContext.class);
        }
        if (requiredContext == null) {
            throw new IllegalStateException("@RequiredContext not found on " + this.getManagedType().getName() + " or " + this.getClass().getName());
        }
        for (Named n : requiredContext.value()) {
            attrs.add(new CapabilityContext.Attribute(n.value(), true));
        }
        return new CapabilityContext(attrs);
    }

    protected void dispose(ExposedObject<T> exposedObject) {
    }

    @Override
    public Collection<ExposedObject<T>> getExposedObjects() {
        return this.exposedObjects;
    }

    protected abstract ExposedObject<T> wrap(T var1);

    @Override
    protected ExposedObject<T> findExposedObject(Context context) {
        if (!this.contextValid(context)) {
            return null;
        }
        for (ExposedObject exposedObject : this.exposedObjects) {
            if (!context.contains(exposedObject.getContext())) continue;
            return exposedObject;
        }
        return null;
    }

    @Override
    public ExposedObject<T> findExposedObject(T managedObject) {
        for (ExposedObject exposedObject : this.exposedObjects) {
            if (!exposedObject.getTarget().equals(managedObject)) continue;
            return exposedObject;
        }
        return null;
    }

    private boolean contextValid(Context context) {
        if (context == null) {
            return false;
        }
        for (CapabilityContext.Attribute attribute : this.getCapabilityContext().getAttributes()) {
            if (context.get(attribute.getName()) != null) continue;
            return false;
        }
        return true;
    }
}

