/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.Collection;
import java.util.Collections;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.registry.CallQuery;
import org.terracotta.management.registry.CapabilityManagement;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultCallQueryBuilder;
import org.terracotta.management.registry.DefaultStatisticQueryBuilder;
import org.terracotta.management.registry.StatisticQuery;

public class DefaultCapabilityManagement
implements CapabilityManagement {
    private final String capabilityName;
    private final CapabilityManagementSupport capabilityManagement;

    public DefaultCapabilityManagement(CapabilityManagementSupport capabilityManagement, String capabilityName) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
    }

    @Override
    public StatisticQuery.Builder queryStatistic(String statisticName) {
        return new DefaultStatisticQueryBuilder(this.capabilityManagement, this.capabilityName, Collections.singletonList(statisticName));
    }

    @Override
    public StatisticQuery.Builder queryStatistics(Collection<String> statisticNames) {
        return new DefaultStatisticQueryBuilder(this.capabilityManagement, this.capabilityName, statisticNames);
    }

    @Override
    public StatisticQuery.Builder queryAllStatistics() {
        return new DefaultStatisticQueryBuilder(this.capabilityManagement, this.capabilityName);
    }

    @Override
    public <T> CallQuery.Builder<T> call(String methodName, Class<T> returnType, Parameter ... parameters) {
        return new DefaultCallQueryBuilder<T>(this.capabilityManagement, this.capabilityName, methodName, returnType, parameters);
    }

    @Override
    public CallQuery.Builder<?> call(String methodName, Parameter ... parameters) {
        return new DefaultCallQueryBuilder<Object>(this.capabilityManagement, this.capabilityName, methodName, Object.class, parameters);
    }
}

