/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.context.ContextContainer;
import org.terracotta.management.registry.CapabilityManagement;
import org.terracotta.management.registry.DefaultCapabilityManagement;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ManagementRegistry;

public class DefaultManagementRegistry
implements ManagementRegistry {
    private final ContextContainer contextContainer;
    private static final Comparator<Capability> CAPABILITY_COMPARATOR = new Comparator<Capability>(){

        @Override
        public int compare(Capability o1, Capability o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    protected final List<ManagementProvider<?>> managementProviders = new CopyOnWriteArrayList();

    public DefaultManagementRegistry(ContextContainer contextContainer) {
        this.contextContainer = contextContainer;
    }

    @Override
    public void addManagementProvider(ManagementProvider<?> provider) {
        String name = provider.getCapabilityName();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getCapabilityName().equals(name)) continue;
            throw new IllegalStateException("Duplicated management provider name : " + name);
        }
        this.managementProviders.add(provider);
    }

    @Override
    public void removeManagementProvider(ManagementProvider<?> provider) {
        this.managementProviders.remove(provider);
    }

    @Override
    public void register(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getManagedType().isInstance(managedObject)) continue;
            managementProvider.register(managedObject);
        }
    }

    @Override
    public void unregister(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getManagedType().isInstance(managedObject)) continue;
            managementProvider.unregister(managedObject);
        }
    }

    @Override
    public CapabilityManagement withCapability(String capabilityName) {
        return new DefaultCapabilityManagement(this, capabilityName);
    }

    @Override
    public Collection<? extends Capability> getCapabilities() {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            capabilities.add(managementProvider.getCapability());
        }
        Collections.sort(capabilities, CAPABILITY_COMPARATOR);
        return capabilities;
    }

    @Override
    public Collection<String> getCapabilityNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            names.add(managementProvider.getCapabilityName());
        }
        return names;
    }

    public List<ManagementProvider<?>> getManagementProvidersByCapability(String capabilityName) {
        ArrayList allProviders = new ArrayList();
        for (ManagementProvider<?> provider : this.managementProviders) {
            if (!provider.getCapabilityName().equals(capabilityName)) continue;
            allProviders.add(provider);
        }
        return allProviders;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.contextContainer;
    }
}

