/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.ContextualStatistics;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultResultSet;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ResultSet;
import org.terracotta.management.registry.StatisticQuery;

public class DefaultStatisticQuery
implements StatisticQuery {
    private final CapabilityManagementSupport capabilityManagement;
    private final String capabilityName;
    private final Collection<String> statisticNames;
    private final Collection<Context> contexts;

    public DefaultStatisticQuery(CapabilityManagementSupport capabilityManagement, String capabilityName, Collection<String> statisticNames, Collection<Context> contexts) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
        this.statisticNames = Collections.unmodifiableSet(new LinkedHashSet<String>(statisticNames));
        this.contexts = Collections.unmodifiableCollection(new ArrayList<Context>(contexts));
        if (contexts.isEmpty()) {
            throw new IllegalArgumentException("You did not specify any context to extract the statistics from");
        }
    }

    @Override
    public String getCapabilityName() {
        return this.capabilityName;
    }

    @Override
    public Collection<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public Collection<String> getStatisticNames() {
        return this.statisticNames;
    }

    @Override
    public ResultSet<ContextualStatistics> execute() {
        LinkedHashMap<Context, ContextualStatistics> contextualStatistics = new LinkedHashMap<Context, ContextualStatistics>(this.contexts.size());
        Collection<ManagementProvider<?>> managementProviders = this.capabilityManagement.getManagementProvidersByCapability(this.capabilityName);
        for (Context context : this.contexts) {
            HashMap<String, Number> statistics = new HashMap<String, Number>();
            for (ManagementProvider<?> managementProvider : managementProviders) {
                if (!managementProvider.supports(context)) continue;
                for (Map.Entry<String, Number> entry : managementProvider.collectStatistics(context, this.statisticNames).entrySet()) {
                    if (entry.getValue() == null || !(entry.getValue().doubleValue() >= 0.0) && entry.getValue().doubleValue() != Double.NaN) continue;
                    statistics.put(entry.getKey(), entry.getValue());
                }
            }
            contextualStatistics.put(context, new ContextualStatistics(this.capabilityName, context, statistics));
        }
        return new DefaultResultSet<ContextualStatistics>(contextualStatistics);
    }
}

