/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultStatisticQuery;
import org.terracotta.management.registry.StatisticQuery;

public class DefaultStatisticQueryBuilder
implements StatisticQuery.Builder {
    private final CapabilityManagementSupport capabilityManagement;
    private final String capabilityName;
    private final Collection<String> statisticNames;
    private final Collection<Context> contexts;

    DefaultStatisticQueryBuilder(CapabilityManagementSupport capabilityManagement, String capabilityName, Collection<String> statisticNames) {
        this(capabilityManagement, capabilityName, statisticNames, Collections.emptyList());
    }

    DefaultStatisticQueryBuilder(CapabilityManagementSupport capabilityManagement, String capabilityName) {
        this(capabilityManagement, capabilityName, Collections.emptyList(), Collections.emptyList());
    }

    private DefaultStatisticQueryBuilder(CapabilityManagementSupport capabilityManagement, String capabilityName, Collection<String> statisticNames, Collection<Context> contexts) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
        this.statisticNames = new LinkedHashSet<String>(statisticNames);
        this.contexts = contexts;
    }

    @Override
    public StatisticQuery build() {
        return new DefaultStatisticQuery(this.capabilityManagement, this.capabilityName, this.statisticNames, this.contexts);
    }

    @Override
    public StatisticQuery.Builder on(Context context) {
        if (!this.contexts.contains(context)) {
            ArrayList<Context> contexts = new ArrayList<Context>(this.contexts);
            contexts.add(context);
            return new DefaultStatisticQueryBuilder(this.capabilityManagement, this.capabilityName, this.statisticNames, contexts);
        }
        return this;
    }

    @Override
    public StatisticQuery.Builder on(Collection<? extends Context> contexts) {
        StatisticQuery.Builder newBuilder = this;
        for (Context context : contexts) {
            newBuilder = (StatisticQuery.Builder)newBuilder.on(context);
        }
        return newBuilder;
    }
}

