/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry.collect;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.ContextualStatistics;
import org.terracotta.management.registry.CapabilityManagement;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ResultSet;
import org.terracotta.management.registry.StatisticQuery;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.collect.StatisticCollector;
import org.terracotta.management.registry.collect.StatisticProvider;

public class DefaultStatisticCollector
implements StatisticCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticCollector.class);
    private final CapabilityManagementSupport managementRegistry;
    private final ScheduledExecutorService scheduledExecutorService;
    private final StatisticCollector.Collector collector;
    private ScheduledFuture<?> task;

    public DefaultStatisticCollector(CapabilityManagementSupport capabilityManagementSupport, ScheduledExecutorService scheduledExecutorService, StatisticCollector.Collector collector) {
        this.managementRegistry = Objects.requireNonNull(capabilityManagementSupport);
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        this.collector = Objects.requireNonNull(collector);
    }

    @Override
    public synchronized void startStatisticCollector(long interval, TimeUnit unit) {
        if (this.task == null) {
            LOGGER.trace("startStatisticCollector({}, {})", (Object)interval, (Object)unit);
            this.task = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DefaultStatisticCollector.this.task != null) {
                            ArrayList<ContextualStatistics> statistics = new ArrayList<ContextualStatistics>();
                            for (String capabilityName : DefaultStatisticCollector.this.managementRegistry.getCapabilityNames()) {
                                LinkedHashSet<Context> allContexts = new LinkedHashSet<Context>();
                                for (ManagementProvider<?> managementProvider : DefaultStatisticCollector.this.managementRegistry.getManagementProvidersByCapability(capabilityName)) {
                                    if (!managementProvider.getClass().isAnnotationPresent(StatisticProvider.class)) continue;
                                    for (ExposedObject<?> exposedObject : managementProvider.getExposedObjects()) {
                                        allContexts.add(exposedObject.getContext());
                                    }
                                }
                                if (allContexts.isEmpty()) continue;
                                CapabilityManagement capabilityManagement = DefaultStatisticCollector.this.managementRegistry.withCapability(capabilityName);
                                ResultSet resultSet = ((StatisticQuery)((StatisticQuery.Builder)capabilityManagement.queryAllStatistics().on(allContexts)).build()).execute();
                                for (ContextualStatistics contextualStatistics : resultSet) {
                                    statistics.add(contextualStatistics);
                                }
                            }
                            if (DefaultStatisticCollector.this.task != null && !statistics.isEmpty()) {
                                DefaultStatisticCollector.this.collector.onStatistics(statistics);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("StatisticCollector failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }, 0L, interval, unit);
        }
    }

    @Override
    public synchronized void stopStatisticCollector() {
        if (this.task != null) {
            LOGGER.trace("stopStatisticCollector()");
            ScheduledFuture<?> _task = this.task;
            this.task = null;
            _task.cancel(false);
        }
    }
}

