/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.action.AbstractActionManagementProvider;
import org.terracotta.management.registry.action.Exposed;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.collect.StatisticCollector;

@Named(value="StatisticCollectorCapability")
public class StatisticCollectorProvider
extends AbstractActionManagementProvider<StatisticCollector> {
    private final Context context;

    public StatisticCollectorProvider(Context context) {
        super(StatisticCollector.class);
        this.context = context;
    }

    @Override
    protected ExposedObject<StatisticCollector> wrap(StatisticCollector managedObject) {
        return new ExposedStatisticCollector(managedObject, this.context);
    }

    @Override
    protected void dispose(ExposedObject<StatisticCollector> exposedObject) {
        exposedObject.getTarget().stopStatisticCollector();
    }

    public static class ExposedStatisticCollector
    implements ExposedObject<StatisticCollector> {
        private final StatisticCollector collectorService;
        private final Context context;

        public ExposedStatisticCollector(StatisticCollector collectorService, Context context) {
            this.collectorService = collectorService;
            this.context = context;
        }

        @Exposed
        public void stopStatisticCollector() {
            this.collectorService.stopStatisticCollector();
        }

        @Exposed
        public void startStatisticCollector(@Named(value="interval") long interval, @Named(value="unit") TimeUnit unit) {
            this.collectorService.startStatisticCollector(interval, unit);
        }

        @Override
        public StatisticCollector getTarget() {
            return this.collectorService;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.collectorService.getClass().getClassLoader();
        }

        @Override
        public Collection<? extends Descriptor> getDescriptors() {
            return Collections.emptyList();
        }

        @Override
        public Context getContext() {
            return this.context;
        }
    }
}

